/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SourcePosition;
import com.google.javascript.rhino.Token;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class JSDocInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LazilyInitializedInfo info;
    private LazilyInitializedDocumentation documentation;
    private Visibility visibility;
    private int bitset;
    private JSTypeExpression type;
    private JSTypeExpression thisType;
    private boolean inlineType;
    private boolean includeDocumentation;
    private int originalCommentPosition;
    private static final int MASK_FLAGS = 0x3FFFFFFF;
    private static final int MASK_CONSTANT = 1;
    private static final int MASK_CONSTRUCTOR = 2;
    private static final int MASK_DEFINE = 4;
    private static final int MASK_HIDDEN = 8;
    private static final int MASK_TYPE_SUMMARY = 16;
    private static final int MASK_FINAL = 32;
    private static final int MASK_OVERRIDE = 64;
    private static final int MASK_UNUSED_1 = 128;
    private static final int MASK_DEPRECATED = 256;
    private static final int MASK_INTERFACE = 512;
    private static final int MASK_EXPORT = 1024;
    private static final int MASK_NOINLINE = 2048;
    private static final int MASK_FILEOVERVIEW = 4096;
    private static final int MASK_IMPLICITCAST = 8192;
    private static final int MASK_NOSIDEEFFECTS = 16384;
    private static final int MASK_EXTERNS = 32768;
    private static final int MASK_XIDGEN = 65536;
    private static final int MASK_NOCOMPILE = 131072;
    private static final int MASK_CONSISTIDGEN = 262144;
    private static final int MASK_IDGEN = 524288;
    private static final int MASK_EXPOSE = 0x100000;
    private static final int MASK_UNRESTRICTED = 0x200000;
    private static final int MASK_STRUCT = 0x400000;
    private static final int MASK_DICT = 0x800000;
    private static final int MASK_STABLEIDGEN = 0x1000000;
    private static final int MASK_MAPPEDIDGEN = 0x2000000;
    private static final int MASK_NOCOLLAPSE = 0x4000000;
    private static final int MASK_RECORD = 0x8000000;
    private static final int MASK_ABSTRACT = 0x10000000;
    private static final int MASK_TYPEFIELD = -536870912;
    private static final int TYPEFIELD_TYPE = 0x20000000;
    private static final int TYPEFIELD_RETURN = 0x40000000;
    private static final int TYPEFIELD_ENUM = 0x60000000;
    private static final int TYPEFIELD_TYPEDEF = Integer.MIN_VALUE;

    JSDocInfo(boolean includeDocumentation) {
        this.includeDocumentation = includeDocumentation;
    }

    JSDocInfo() {
    }

    public JSDocInfo clone() {
        return this.clone(false);
    }

    public JSDocInfo clone(boolean cloneTypeNodes) {
        JSDocInfo other = new JSDocInfo();
        other.info = this.info == null ? null : this.info.clone(cloneTypeNodes);
        other.documentation = this.documentation;
        other.visibility = this.visibility;
        other.bitset = this.bitset;
        other.type = JSDocInfo.cloneType(this.type, cloneTypeNodes);
        other.thisType = JSDocInfo.cloneType(this.thisType, cloneTypeNodes);
        other.includeDocumentation = this.includeDocumentation;
        other.originalCommentPosition = this.originalCommentPosition;
        return other;
    }

    private static JSTypeExpression cloneType(JSTypeExpression expr, boolean cloneTypeNodes) {
        if (expr != null) {
            return cloneTypeNodes ? expr.copy() : expr;
        }
        return null;
    }

    @VisibleForTesting
    public static boolean areEquivalent(JSDocInfo jsDoc1, JSDocInfo jsDoc2) {
        if (jsDoc1 == null && jsDoc2 == null) {
            return true;
        }
        if (jsDoc1 == null || jsDoc2 == null) {
            return false;
        }
        if (!Objects.equals(jsDoc1.getParameterNames(), jsDoc2.getParameterNames())) {
            return false;
        }
        for (String param : jsDoc1.getParameterNames()) {
            if (Objects.equals(jsDoc1.getParameterType(param), jsDoc2.getParameterType(param))) continue;
            return false;
        }
        if (jsDoc1.getMarkers().size() != jsDoc2.getMarkers().size()) {
            return false;
        }
        Iterator<Marker> it1 = jsDoc1.getMarkers().iterator();
        Iterator<Marker> it2 = jsDoc2.getMarkers().iterator();
        while (it1.hasNext()) {
            if (Marker.areEquivalent(it1.next(), it2.next())) continue;
            return false;
        }
        return Objects.equals(jsDoc1.getAuthors(), jsDoc2.getAuthors()) && Objects.equals(jsDoc1.getBaseType(), jsDoc2.getBaseType()) && Objects.equals(jsDoc1.getBlockDescription(), jsDoc2.getBlockDescription()) && Objects.equals(jsDoc1.getFileOverview(), jsDoc2.getFileOverview()) && Objects.equals(jsDoc1.getImplementedInterfaces(), jsDoc2.getImplementedInterfaces()) && Objects.equals(jsDoc1.getEnumParameterType(), jsDoc2.getEnumParameterType()) && Objects.equals(jsDoc1.getExtendedInterfaces(), jsDoc2.getExtendedInterfaces()) && Objects.equals(jsDoc1.getLendsName(), jsDoc2.getLendsName()) && Objects.equals(jsDoc1.getLicense(), jsDoc2.getLicense()) && Objects.equals(jsDoc1.getMeaning(), jsDoc2.getMeaning()) && Objects.equals(jsDoc1.getModifies(), jsDoc2.getModifies()) && Objects.equals(jsDoc1.getOriginalCommentString(), jsDoc2.getOriginalCommentString()) && jsDoc1.getPropertyBitField() == jsDoc2.getPropertyBitField() && Objects.equals(jsDoc1.getReferences(), jsDoc2.getReferences()) && Objects.equals(jsDoc1.getReturnDescription(), jsDoc2.getReturnDescription()) && Objects.equals(jsDoc1.getReturnType(), jsDoc2.getReturnType()) && Objects.equals(jsDoc1.getSuppressions(), jsDoc2.getSuppressions()) && Objects.equals(jsDoc1.getTemplateTypeNames(), jsDoc2.getTemplateTypeNames()) && Objects.equals(jsDoc1.getThisType(), jsDoc2.getThisType()) && Objects.equals(jsDoc1.getThrownTypes(), jsDoc2.getThrownTypes()) && Objects.equals(jsDoc1.getTypedefType(), jsDoc2.getTypedefType()) && Objects.equals(jsDoc1.getType(), jsDoc2.getType()) && Objects.equals(jsDoc1.getVersion(), jsDoc2.getVersion()) && Objects.equals((Object)jsDoc1.getVisibility(), (Object)jsDoc2.getVisibility()) && Objects.equals(jsDoc1.getClosurePrimitiveId(), jsDoc2.getClosurePrimitiveId()) && jsDoc1.bitset == jsDoc2.bitset;
    }

    boolean isDocumentationIncluded() {
        return this.includeDocumentation;
    }

    void setConsistentIdGenerator(boolean value) {
        this.setFlag(value, 262144);
    }

    void setStableIdGenerator(boolean value) {
        this.setFlag(value, 0x1000000);
    }

    void setXidGenerator(boolean value) {
        this.setFlag(value, 65536);
    }

    void setMappedIdGenerator(boolean value) {
        this.setFlag(value, 0x2000000);
    }

    void setConstant(boolean value) {
        this.setFlag(value, 1);
    }

    void setFinal(boolean value) {
        this.setFlag(value, 32);
    }

    void setConstructor(boolean value) {
        this.setFlag(value, 2);
    }

    void setAbstract() {
        this.setFlag(true, 0x10000000);
    }

    void setUnrestricted() {
        this.setFlag(true, 0x200000);
    }

    void setStruct() {
        this.setStruct(true);
    }

    void setStruct(boolean value) {
        this.setFlag(value, 0x400000);
    }

    void setDict() {
        this.setFlag(true, 0x800000);
    }

    void setDefine(boolean value) {
        this.setFlag(value, 4);
    }

    void setHidden(boolean value) {
        this.setFlag(value, 8);
    }

    void setOverride(boolean value) {
        this.setFlag(value, 64);
    }

    void setDeprecated(boolean value) {
        this.setFlag(value, 256);
    }

    void setInterface(boolean value) {
        this.setFlag(value, 512);
    }

    void setExport(boolean value) {
        this.setFlag(value, 1024);
    }

    void setExpose(boolean value) {
        this.setFlag(value, 0x100000);
    }

    void setIdGenerator(boolean value) {
        this.setFlag(value, 524288);
    }

    void setImplicitCast(boolean value) {
        this.setFlag(value, 8192);
    }

    void setNoSideEffects(boolean value) {
        this.setFlag(value, 16384);
    }

    void setExterns(boolean value) {
        this.setFlag(value, 32768);
    }

    void setTypeSummary(boolean value) {
        this.setFlag(value, 16);
    }

    void setNoCompile(boolean value) {
        this.setFlag(value, 131072);
    }

    void setNoCollapse(boolean value) {
        this.setFlag(value, 0x4000000);
    }

    void setNoInline(boolean value) {
        this.setFlag(value, 2048);
    }

    private void setFlag(boolean value, int mask) {
        this.bitset = value ? (this.bitset |= mask) : (this.bitset &= ~mask);
    }

    void setImplicitMatch(boolean value) {
        this.setFlag(value, 0x8000000);
    }

    public boolean isConsistentIdGenerator() {
        return this.getFlag(262144);
    }

    public boolean isStableIdGenerator() {
        return this.getFlag(0x1000000);
    }

    public boolean isXidGenerator() {
        return this.getFlag(65536);
    }

    public boolean isMappedIdGenerator() {
        return this.getFlag(0x2000000);
    }

    public boolean isConstant() {
        return this.getFlag(37) || this.getDescription() != null;
    }

    public boolean hasConstAnnotation() {
        return this.getFlag(1);
    }

    public boolean isFinal() {
        return this.getFlag(32);
    }

    public boolean isConstructor() {
        return this.getFlag(2);
    }

    public boolean isAbstract() {
        return this.getFlag(0x10000000);
    }

    public boolean usesImplicitMatch() {
        return this.getFlag(0x8000000);
    }

    public boolean makesUnrestricted() {
        return this.getFlag(0x200000);
    }

    public boolean makesStructs() {
        return this.getFlag(0x400000);
    }

    public boolean makesDicts() {
        return this.getFlag(0x800000);
    }

    public boolean isDefine() {
        return this.getFlag(4);
    }

    public boolean isHidden() {
        return this.getFlag(8);
    }

    public boolean isOverride() {
        return this.getFlag(64);
    }

    public boolean isDeprecated() {
        return this.getFlag(256);
    }

    public boolean isInterface() {
        return this.getFlag(512) || this.getFlag(0x8000000);
    }

    public boolean isConstructorOrInterface() {
        return this.isConstructor() || this.isInterface();
    }

    public boolean isExport() {
        return this.getFlag(1024);
    }

    public boolean isExpose() {
        return this.getFlag(0x100000);
    }

    public boolean isIdGenerator() {
        return this.getFlag(524288);
    }

    public boolean isImplicitCast() {
        return this.getFlag(8192);
    }

    public boolean isNoSideEffects() {
        return this.getFlag(16384);
    }

    public boolean isExterns() {
        return this.getFlag(32768);
    }

    public boolean isTypeSummary() {
        return this.getFlag(16);
    }

    public boolean isNoCompile() {
        return this.getFlag(131072);
    }

    public boolean isNoCollapse() {
        return this.getFlag(0x4000000);
    }

    public boolean isNoInline() {
        return this.getFlag(2048);
    }

    public boolean containsDeclarationExcludingTypelessConst() {
        return this.hasType() || this.hasReturnType() || this.hasEnumParameterType() || this.hasTypedefType() || this.hasThisType() || this.getParameterCount() > 0 || this.getImplementedInterfaceCount() > 0 || this.hasBaseType() || this.visibility != Visibility.INHERITED || this.getFlag(135292742);
    }

    public boolean containsDeclaration() {
        return this.containsDeclarationExcludingTypelessConst() || this.getFlag(1);
    }

    @Deprecated
    public boolean containsFunctionDeclaration() {
        boolean hasFunctionType = this.hasType() && this.getType().getRoot().isFunction();
        return hasFunctionType || this.hasReturnType() || this.hasThisType() || this.getParameterCount() > 0 || this.getFlag(2) || this.getFlag(16384) && !this.hasType();
    }

    public boolean containsTypeDefinition() {
        return this.isConstructor() || this.isInterface() || this.hasEnumParameterType() || this.hasTypedefType();
    }

    private boolean getFlag(int mask) {
        return (this.bitset & mask) != 0;
    }

    void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    private void lazyInitInfo() {
        if (this.info == null) {
            this.info = new LazilyInitializedInfo();
        }
    }

    private boolean lazyInitDocumentation() {
        if (!this.includeDocumentation) {
            return false;
        }
        if (this.documentation == null) {
            this.documentation = new LazilyInitializedDocumentation();
        }
        return true;
    }

    public boolean isAtSignCodePresent() {
        String entireComment = this.getOriginalCommentString();
        return entireComment == null ? false : entireComment.contains("@code");
    }

    Marker addMarker() {
        if (!this.lazyInitDocumentation()) {
            return null;
        }
        if (this.documentation.markers == null) {
            this.documentation.markers = new ArrayList();
        }
        Marker marker = new Marker();
        this.documentation.markers.add(marker);
        return marker;
    }

    boolean setDeprecationReason(String reason) {
        this.lazyInitInfo();
        if (this.info.deprecated != null) {
            return false;
        }
        this.info.deprecated = reason;
        return true;
    }

    void addSuppression(String suppression) {
        this.lazyInitInfo();
        if (this.info.suppressions == null) {
            this.info.suppressions = ImmutableSet.of(suppression);
        } else {
            this.info.suppressions = (ImmutableSet)((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)this.info.suppressions)).add(suppression)).build();
        }
    }

    void addSuppressions(Set<String> suppressions) {
        this.lazyInitInfo();
        if (this.info.suppressions != null) {
            suppressions = Sets.union(suppressions, this.info.suppressions);
        }
        this.info.suppressions = ImmutableSet.copyOf(suppressions);
    }

    boolean setModifies(Set<String> modifies) {
        this.lazyInitInfo();
        if (this.info.modifies != null) {
            return false;
        }
        this.info.modifies = ImmutableSet.copyOf(modifies);
        return true;
    }

    boolean documentVersion(String version) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.version != null) {
            return false;
        }
        this.documentation.version = version;
        return true;
    }

    boolean documentReference(String reference) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.sees == null) {
            this.documentation.sees = new ArrayList();
        }
        this.documentation.sees.add(reference);
        return true;
    }

    boolean documentAuthor(String author) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.authors == null) {
            this.documentation.authors = new ArrayList();
        }
        this.documentation.authors.add(author);
        return true;
    }

    boolean documentThrows(JSTypeExpression type, String throwsDescription) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.throwsDescriptions == null) {
            this.documentation.throwsDescriptions = new LinkedHashMap();
        }
        if (!this.documentation.throwsDescriptions.containsKey(type)) {
            this.documentation.throwsDescriptions.put(type, throwsDescription);
            return true;
        }
        return false;
    }

    boolean documentParam(String parameter, String description) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.parameters == null) {
            this.documentation.parameters = new LinkedHashMap();
        }
        if (!this.documentation.parameters.containsKey(parameter)) {
            this.documentation.parameters.put(parameter, description);
            return true;
        }
        return false;
    }

    boolean documentBlock(String description) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.blockDescription != null) {
            return false;
        }
        this.documentation.blockDescription = description;
        return true;
    }

    boolean documentFileOverview(String description) {
        this.setFlag(true, 4096);
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.fileOverview != null) {
            return false;
        }
        this.documentation.fileOverview = description;
        return true;
    }

    boolean documentReturn(String description) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.returnDescription != null) {
            return false;
        }
        this.documentation.returnDescription = description;
        return true;
    }

    boolean declareParam(JSTypeExpression jsType, String parameter) {
        this.lazyInitInfo();
        if (this.info.parameters == null) {
            this.info.parameters = new LinkedHashMap();
        }
        if (!this.info.parameters.containsKey(parameter)) {
            this.info.parameters.put(parameter, jsType);
            return true;
        }
        return false;
    }

    boolean declareTemplateTypeName(String newTemplateTypeName) {
        this.lazyInitInfo();
        return this.declareTemplateTypeName(newTemplateTypeName, null);
    }

    boolean declareTemplateTypeName(String newTemplateTypeName, JSTypeExpression newTemplateTypeBound) {
        this.lazyInitInfo();
        JSTypeExpression jSTypeExpression = newTemplateTypeBound = newTemplateTypeBound == null ? new JSTypeExpression(new Node(Token.QMARK), "") : newTemplateTypeBound;
        if (this.isTypeTransformationName(newTemplateTypeName) || this.hasTypedefType()) {
            return false;
        }
        if (this.info.templateTypeNames == null) {
            this.info.templateTypeNames = new LinkedHashMap();
        } else if (this.info.templateTypeNames.containsKey(newTemplateTypeName)) {
            return false;
        }
        this.info.templateTypeNames.put(newTemplateTypeName, newTemplateTypeBound);
        return true;
    }

    private boolean isTemplateTypeName(String name) {
        if (this.info.templateTypeNames == null) {
            return false;
        }
        return this.info.templateTypeNames.containsKey(name);
    }

    private boolean isTypeTransformationName(String name) {
        if (this.info.typeTransformations == null) {
            return false;
        }
        return this.info.typeTransformations.containsKey(name);
    }

    boolean declareTypeTransformation(String newName, Node expr) {
        this.lazyInitInfo();
        if (this.isTemplateTypeName(newName)) {
            return false;
        }
        if (this.info.typeTransformations == null) {
            this.info.typeTransformations = new LinkedHashMap();
        } else if (this.info.typeTransformations.containsKey(newName)) {
            return false;
        }
        this.info.typeTransformations.put(newName, expr);
        return true;
    }

    boolean declareThrows(JSTypeExpression jsType) {
        this.lazyInitInfo();
        if (this.info.thrownTypes == null) {
            this.info.thrownTypes = new ArrayList();
        }
        this.info.thrownTypes.add(jsType);
        return true;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public JSTypeExpression getParameterType(String parameter) {
        if (this.info == null || this.info.parameters == null) {
            return null;
        }
        return (JSTypeExpression)this.info.parameters.get(parameter);
    }

    public boolean hasParameter(String parameter) {
        if (this.info == null || this.info.parameters == null) {
            return false;
        }
        return this.info.parameters.containsKey(parameter);
    }

    public boolean hasParameterType(String parameter) {
        return this.getParameterType(parameter) != null;
    }

    public Set<String> getParameterNames() {
        if (this.info == null || this.info.parameters == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(this.info.parameters.keySet());
    }

    public String getParameterNameAt(int index) {
        if (this.info == null || this.info.parameters == null) {
            return null;
        }
        if (index >= this.info.parameters.size()) {
            return null;
        }
        return (String)Iterables.get(this.info.parameters.keySet(), index);
    }

    public int getParameterCount() {
        if (this.info == null || this.info.parameters == null) {
            return 0;
        }
        return this.info.parameters.size();
    }

    void setInlineType() {
        this.inlineType = true;
    }

    void setReturnType(JSTypeExpression type) {
        this.setType(type, 0x40000000);
    }

    void setEnumParameterType(JSTypeExpression type) {
        this.setType(type, 0x60000000);
    }

    boolean declareTypedefType(JSTypeExpression type) {
        if (this.getTemplateTypeNames().isEmpty()) {
            this.setType(type, Integer.MIN_VALUE);
            return true;
        }
        return false;
    }

    void setType(JSTypeExpression type) {
        this.setType(type, 0x20000000);
    }

    private void setType(JSTypeExpression type, int mask) {
        if ((this.bitset & 0xE0000000) != 0) {
            throw new IllegalStateException("API tried to add two incompatible type tags. This should have been blocked and emitted a warning.");
        }
        this.bitset = this.bitset & 0x3FFFFFFF | mask;
        this.type = type;
    }

    public List<JSTypeExpression> getThrownTypes() {
        if (this.info == null || this.info.thrownTypes == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.info.thrownTypes);
    }

    public String getThrowsDescriptionForType(JSTypeExpression type) {
        if (this.documentation == null || this.documentation.throwsDescriptions == null) {
            return null;
        }
        return (String)this.documentation.throwsDescriptions.get(type);
    }

    public boolean hasEnumParameterType() {
        return this.hasType(0x60000000);
    }

    public boolean hasTypedefType() {
        return this.hasType(Integer.MIN_VALUE);
    }

    public boolean hasReturnType() {
        return this.hasType(0x40000000);
    }

    public boolean hasType() {
        return this.hasType(0x20000000);
    }

    private boolean hasType(int mask) {
        return (this.bitset & 0xE0000000) == mask;
    }

    public boolean hasTypeInformation() {
        return (this.bitset & 0xE0000000) != 0;
    }

    public boolean isInlineType() {
        return this.inlineType;
    }

    public JSTypeExpression getReturnType() {
        return this.getType(0x40000000);
    }

    public JSTypeExpression getEnumParameterType() {
        return this.getType(0x60000000);
    }

    public JSTypeExpression getTypedefType() {
        return this.getType(Integer.MIN_VALUE);
    }

    public JSTypeExpression getType() {
        return this.getType(0x20000000);
    }

    private JSTypeExpression getType(int typefield) {
        if ((0xE0000000 & this.bitset) == typefield) {
            return this.type;
        }
        return null;
    }

    public JSTypeExpression getThisType() {
        return this.thisType;
    }

    void setThisType(JSTypeExpression type) {
        this.thisType = type;
    }

    public boolean hasThisType() {
        return this.thisType != null;
    }

    void setBaseType(JSTypeExpression type) {
        this.lazyInitInfo();
        this.info.baseType = type;
    }

    public JSTypeExpression getBaseType() {
        return this.info == null ? null : this.info.baseType;
    }

    public String getDescription() {
        return this.info == null ? null : this.info.description;
    }

    void setDescription(String desc) {
        this.lazyInitInfo();
        this.info.description = desc;
    }

    public String getMeaning() {
        return this.info == null ? null : this.info.meaning;
    }

    void setMeaning(String meaning) {
        this.lazyInitInfo();
        this.info.meaning = meaning;
    }

    public JSTypeExpression getLendsName() {
        return this.info == null ? null : this.info.lendsName;
    }

    void setLendsName(JSTypeExpression name) {
        this.lazyInitInfo();
        this.info.lendsName = name;
    }

    public boolean hasLendsName() {
        return this.getLendsName() != null;
    }

    void setClosurePrimitiveId(String closurePrimitiveId) {
        this.lazyInitInfo();
        this.info.closurePrimitiveId = closurePrimitiveId;
    }

    public String getClosurePrimitiveId() {
        return this.info == null ? null : this.info.closurePrimitiveId;
    }

    public boolean hasClosurePrimitiveId() {
        return this.getClosurePrimitiveId() != null;
    }

    public boolean isNgInject() {
        return this.info != null && this.info.isBitSet(0);
    }

    void setNgInject(boolean ngInject) {
        this.lazyInitInfo();
        this.info.setBit(0, ngInject);
    }

    public boolean isWizaction() {
        return this.info != null && this.info.isBitSet(1);
    }

    void setWizaction(boolean wizaction) {
        this.lazyInitInfo();
        this.info.setBit(1, wizaction);
    }

    public boolean isPolymerBehavior() {
        return this.info != null && this.info.isBitSet(2);
    }

    void setPolymerBehavior(boolean polymerBehavior) {
        this.lazyInitInfo();
        this.info.setBit(2, polymerBehavior);
    }

    public boolean isPolymer() {
        return this.info != null && this.info.isBitSet(3);
    }

    void setPolymer(boolean polymer) {
        this.lazyInitInfo();
        this.info.setBit(3, polymer);
    }

    public boolean isCustomElement() {
        return this.info != null && this.info.isBitSet(4);
    }

    void setCustomElement(boolean customElement) {
        this.lazyInitInfo();
        this.info.setBit(4, customElement);
    }

    public boolean isMixinClass() {
        return this.info != null && this.info.isBitSet(5);
    }

    void setMixinClass(boolean mixinClass) {
        this.lazyInitInfo();
        this.info.setBit(5, mixinClass);
    }

    public boolean isMixinFunction() {
        return this.info != null && this.info.isBitSet(6);
    }

    void setMixinFunction(boolean mixinFunction) {
        this.lazyInitInfo();
        this.info.setBit(6, mixinFunction);
    }

    public boolean isDisposes() {
        return this.info == null ? false : this.info.disposedParameters != null;
    }

    boolean setDisposedParameter(String parameterName) {
        this.lazyInitInfo();
        if (this.info.disposedParameters == null) {
            this.info.disposedParameters = new HashSet();
        }
        if (this.info.disposedParameters.contains(parameterName)) {
            return false;
        }
        this.info.disposedParameters.add(parameterName);
        return true;
    }

    public boolean disposesOf(String parameterName) {
        return this.isDisposes() && this.info.disposedParameters.contains(parameterName);
    }

    public String getLicense() {
        return this.info == null ? null : this.info.license;
    }

    void setLicense(String license) {
        this.lazyInitInfo();
        this.info.license = license;
    }

    public String toString() {
        return "JSDocInfo";
    }

    @VisibleForTesting
    public String toStringVerbose() {
        return MoreObjects.toStringHelper(this).add("bitset", this.bitset == 0 ? null : Integer.toHexString(this.bitset)).add("documentation", this.documentation).add("info", this.info).add("originalComment", this.getOriginalCommentString()).add("thisType", this.thisType).add("type", this.type).add("visibility", (Object)this.visibility).omitNullValues().toString();
    }

    public boolean hasBaseType() {
        return this.getBaseType() != null;
    }

    boolean addImplementedInterface(JSTypeExpression interfaceName) {
        this.lazyInitInfo();
        if (this.info.implementedInterfaces == null) {
            this.info.implementedInterfaces = new ArrayList(2);
        }
        if (this.info.implementedInterfaces.contains(interfaceName)) {
            return false;
        }
        this.info.implementedInterfaces.add(interfaceName);
        return true;
    }

    public List<JSTypeExpression> getImplementedInterfaces() {
        if (this.info == null || this.info.implementedInterfaces == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.info.implementedInterfaces);
    }

    public int getImplementedInterfaceCount() {
        if (this.info == null || this.info.implementedInterfaces == null) {
            return 0;
        }
        return this.info.implementedInterfaces.size();
    }

    boolean addExtendedInterface(JSTypeExpression type) {
        this.lazyInitInfo();
        if (this.info.extendedInterfaces == null) {
            this.info.extendedInterfaces = new ArrayList(2);
        }
        if (this.info.extendedInterfaces.contains(type)) {
            return false;
        }
        this.info.extendedInterfaces.add(type);
        return true;
    }

    public List<JSTypeExpression> getExtendedInterfaces() {
        if (this.info == null || this.info.extendedInterfaces == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.info.extendedInterfaces);
    }

    public int getExtendedInterfacesCount() {
        if (this.info == null || this.info.extendedInterfaces == null) {
            return 0;
        }
        return this.info.extendedInterfaces.size();
    }

    public String getDeprecationReason() {
        return this.info == null ? null : this.info.deprecated;
    }

    public Set<String> getSuppressions() {
        ImmutableSet suppressions = this.info == null ? null : this.info.suppressions;
        return suppressions == null ? Collections.emptySet() : suppressions;
    }

    public Set<String> getModifies() {
        ImmutableSet modifies = this.info == null ? null : this.info.modifies;
        return modifies == null ? Collections.emptySet() : modifies;
    }

    private int getPropertyBitField() {
        return this.info == null ? 0 : this.info.propertyBitField;
    }

    void mergePropertyBitfieldFrom(JSDocInfo other) {
        if (other.info != null) {
            this.lazyInitInfo();
            LazilyInitializedInfo lazilyInitializedInfo = this.info;
            lazilyInitializedInfo.propertyBitField = lazilyInitializedInfo.propertyBitField | other.getPropertyBitField();
        }
    }

    public boolean hasDescriptionForParameter(String name) {
        if (this.documentation == null || this.documentation.parameters == null) {
            return false;
        }
        return this.documentation.parameters.containsKey(name);
    }

    public String getDescriptionForParameter(String name) {
        if (this.documentation == null || this.documentation.parameters == null) {
            return null;
        }
        return (String)this.documentation.parameters.get(name);
    }

    public List<String> getAuthors() {
        return this.documentation == null ? null : this.documentation.authors;
    }

    public List<String> getReferences() {
        return this.documentation == null ? null : this.documentation.sees;
    }

    public String getVersion() {
        return this.documentation == null ? null : this.documentation.version;
    }

    public String getReturnDescription() {
        return this.documentation == null ? null : this.documentation.returnDescription;
    }

    public String getBlockDescription() {
        return this.documentation == null ? null : this.documentation.blockDescription;
    }

    public boolean hasFileOverview() {
        return this.getFlag(4096);
    }

    public String getFileOverview() {
        return this.documentation == null ? null : this.documentation.fileOverview;
    }

    public Collection<Marker> getMarkers() {
        return this.documentation == null || this.documentation.markers == null ? ImmutableList.of() : this.documentation.markers;
    }

    public ImmutableList<String> getTemplateTypeNames() {
        if (this.info == null || this.info.templateTypeNames == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.info.templateTypeNames.keySet());
    }

    public ImmutableMap<String, JSTypeExpression> getTemplateTypes() {
        if (this.info == null || this.info.templateTypeNames == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.info.templateTypeNames);
    }

    public ImmutableMap<String, Node> getTypeTransformations() {
        if (this.info == null || this.info.typeTransformations == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.info.typeTransformations);
    }

    public Collection<Node> getTypeNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (this.type != null) {
            nodes.add(this.type.getRoot());
        }
        if (this.thisType != null) {
            nodes.add(this.thisType.getRoot());
        }
        if (this.info != null) {
            if (this.info.baseType != null) {
                nodes.add(this.info.baseType.getRoot());
            }
            if (this.info.extendedInterfaces != null) {
                for (JSTypeExpression interfaceType : this.info.extendedInterfaces) {
                    if (interfaceType == null) continue;
                    nodes.add(interfaceType.getRoot());
                }
            }
            if (this.info.implementedInterfaces != null) {
                for (JSTypeExpression interfaceType : this.info.implementedInterfaces) {
                    if (interfaceType == null) continue;
                    nodes.add(interfaceType.getRoot());
                }
            }
            if (this.info.parameters != null) {
                for (JSTypeExpression parameterType : this.info.parameters.values()) {
                    if (parameterType == null) continue;
                    nodes.add(parameterType.getRoot());
                }
            }
            if (this.info.thrownTypes != null) {
                for (JSTypeExpression thrownType : this.info.thrownTypes) {
                    if (thrownType == null) continue;
                    nodes.add(thrownType.getRoot());
                }
            }
            if (this.info.lendsName != null) {
                nodes.add(this.info.lendsName.getRoot());
            }
        }
        return nodes;
    }

    public boolean hasModifies() {
        return this.info != null && this.info.modifies != null;
    }

    public String getOriginalCommentString() {
        return this.documentation == null ? null : this.documentation.sourceComment;
    }

    void setOriginalCommentString(String sourceComment) {
        if (!this.lazyInitDocumentation()) {
            return;
        }
        this.documentation.sourceComment = sourceComment;
    }

    public int getOriginalCommentPosition() {
        return this.originalCommentPosition;
    }

    void setOriginalCommentPosition(int position) {
        this.originalCommentPosition = position;
    }

    public boolean modifiesThis() {
        return this.getModifies().contains("this");
    }

    public boolean hasSideEffectsArgumentsAnnotation() {
        Set<String> modifies = this.getModifies();
        return modifies.size() > 1 || modifies.size() == 1 && !modifies.contains("this");
    }

    public static final class Marker {
        private TrimmedStringPosition annotation;
        private NamePosition nameNode;
        private StringPosition description;
        private TypePosition type;

        public StringPosition getAnnotation() {
            return this.annotation;
        }

        void setAnnotation(TrimmedStringPosition p) {
            this.annotation = p;
        }

        public NamePosition getNameNode() {
            return this.nameNode;
        }

        void setNameNode(NamePosition p) {
            this.nameNode = p;
        }

        public StringPosition getDescription() {
            return this.description;
        }

        void setDescription(StringPosition p) {
            this.description = p;
        }

        public TypePosition getType() {
            return this.type;
        }

        void setType(TypePosition p) {
            this.type = p;
        }

        private static boolean areEquivalent(Marker m1, Marker m2) {
            if (m1 == null && m2 == null) {
                return true;
            }
            if (m1 == null && m2 != null || m1 != null && m2 == null) {
                return false;
            }
            return TrimmedStringPosition.areEquivalent(m1.annotation, m2.annotation) && NamePosition.areEquivalent(m1.nameNode, m2.nameNode) && StringPosition.areEquivalent(m1.description, m2.description) && TypePosition.areEquivalent(m1.type, m2.type);
        }
    }

    public static class TypePosition
    extends SourcePosition<Node> {
        private boolean brackets = false;

        public boolean hasBrackets() {
            return this.brackets;
        }

        void setHasBrackets(boolean newVal) {
            this.brackets = newVal;
        }

        static boolean areEquivalent(TypePosition p1, TypePosition p2) {
            if (p1 == null && p2 == null) {
                return true;
            }
            if (p1 == null && p2 != null || p1 != null && p2 == null) {
                return false;
            }
            if (p1.getItem() == null && p2.getItem() != null || p1.getItem() != null && p2.getItem() == null) {
                return false;
            }
            return (p1.getItem() == null && p2.getItem() == null || ((Node)p1.getItem()).isEquivalentTo((Node)p2.getItem())) && p1.getStartLine() == p2.getStartLine() && p1.getPositionOnStartLine() == p2.getPositionOnStartLine() && p1.getEndLine() == p2.getEndLine() && p1.getPositionOnEndLine() == p2.getPositionOnEndLine() && p1.brackets == p2.brackets;
        }
    }

    public static class NamePosition
    extends SourcePosition<Node> {
        static boolean areEquivalent(NamePosition p1, NamePosition p2) {
            if (p1 == null && p2 == null) {
                return true;
            }
            if (p1 == null && p2 != null || p1 != null && p2 == null) {
                return false;
            }
            if (p1.getItem() == null && p2.getItem() != null || p1.getItem() != null && p2.getItem() == null) {
                return false;
            }
            return (p1.getItem() == null && p2.getItem() == null || ((Node)p1.getItem()).isEquivalentTo((Node)p2.getItem())) && p1.getStartLine() == p2.getStartLine() && p1.getPositionOnStartLine() == p2.getPositionOnStartLine() && p1.getEndLine() == p2.getEndLine() && p1.getPositionOnEndLine() == p2.getPositionOnEndLine();
        }
    }

    static class TrimmedStringPosition
    extends StringPosition {
        TrimmedStringPosition() {
        }

        @Override
        public void setItem(String item) {
            Preconditions.checkArgument(item.charAt(0) != ' ' && item.charAt(item.length() - 1) != ' ', "String has leading or trailing whitespace");
            super.setItem(item);
        }
    }

    public static class StringPosition
    extends SourcePosition<String> {
        static boolean areEquivalent(StringPosition p1, StringPosition p2) {
            if (p1 == null && p2 == null) {
                return true;
            }
            if (p1 == null && p2 != null || p1 != null && p2 == null) {
                return false;
            }
            return Objects.equals(p1.getItem(), p2.getItem()) && p1.getStartLine() == p2.getStartLine() && p1.getPositionOnStartLine() == p2.getPositionOnStartLine() && p1.getEndLine() == p2.getEndLine() && p1.getPositionOnEndLine() == p2.getPositionOnEndLine();
        }
    }

    private static final class LazilyInitializedDocumentation
    implements Serializable {
        private String sourceComment;
        private ArrayList<Marker> markers;
        private LinkedHashMap<String, String> parameters;
        private LinkedHashMap<JSTypeExpression, String> throwsDescriptions;
        private String blockDescription;
        private String fileOverview;
        private String returnDescription;
        private String version;
        private List<String> authors;
        private List<String> sees;

        private LazilyInitializedDocumentation() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("sourceComment", this.sourceComment).add("markers", this.markers).add("parameters", this.parameters).add("throwsDescriptions", this.throwsDescriptions).add("blockDescription", this.blockDescription).add("fileOverview", this.fileOverview).add("returnDescription", this.returnDescription).add("version", this.version).add("authors", this.authors).add("sees", this.sees).omitNullValues().toString();
        }
    }

    private static final class LazilyInitializedInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private JSTypeExpression baseType;
        private ArrayList<JSTypeExpression> extendedInterfaces;
        private ArrayList<JSTypeExpression> implementedInterfaces;
        private LinkedHashMap<String, JSTypeExpression> parameters;
        private ArrayList<JSTypeExpression> thrownTypes;
        private LinkedHashMap<String, JSTypeExpression> templateTypeNames;
        private Set<String> disposedParameters;
        private LinkedHashMap<String, Node> typeTransformations;
        private String description;
        private String meaning;
        private String deprecated;
        private String license;
        private ImmutableSet<String> suppressions;
        private ImmutableSet<String> modifies;
        private JSTypeExpression lendsName;
        @Nullable
        private String closurePrimitiveId;
        private int propertyBitField;

        private LazilyInitializedInfo() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("bitfield", this.propertyBitField == 0 ? null : Integer.toHexString(this.propertyBitField)).add("baseType", this.baseType).add("extendedInterfaces", this.extendedInterfaces).add("implementedInterfaces", this.implementedInterfaces).add("parameters", this.parameters).add("thrownTypes", this.thrownTypes).add("templateTypeNames", this.templateTypeNames).add("disposedParameters", this.disposedParameters).add("typeTransformations", this.typeTransformations).add("description", this.description).add("meaning", this.meaning).add("deprecated", this.deprecated).add("license", this.license).add("suppressions", this.suppressions).add("modifies", this.modifies).add("lendsName", this.lendsName).add("closurePrimitiveId", this.closurePrimitiveId).omitNullValues().toString();
        }

        protected LazilyInitializedInfo clone() {
            return this.clone(false);
        }

        protected LazilyInitializedInfo clone(boolean cloneTypeNodes) {
            LazilyInitializedInfo other = new LazilyInitializedInfo();
            other.baseType = JSDocInfo.cloneType(this.baseType, cloneTypeNodes);
            other.extendedInterfaces = this.cloneTypeList(this.extendedInterfaces, cloneTypeNodes);
            other.implementedInterfaces = this.cloneTypeList(this.implementedInterfaces, cloneTypeNodes);
            other.parameters = this.cloneTypeMap(this.parameters, cloneTypeNodes);
            other.thrownTypes = this.cloneTypeList(this.thrownTypes, cloneTypeNodes);
            other.templateTypeNames = this.templateTypeNames == null ? null : new LinkedHashMap<String, JSTypeExpression>(this.templateTypeNames);
            other.disposedParameters = this.disposedParameters == null ? null : new HashSet<String>(this.disposedParameters);
            other.typeTransformations = this.typeTransformations == null ? null : new LinkedHashMap<String, Node>(this.typeTransformations);
            other.description = this.description;
            other.meaning = this.meaning;
            other.deprecated = this.deprecated;
            other.license = this.license;
            other.suppressions = this.suppressions == null ? null : ImmutableSet.copyOf(this.suppressions);
            other.modifies = this.modifies == null ? null : ImmutableSet.copyOf(this.modifies);
            other.lendsName = JSDocInfo.cloneType(this.lendsName, cloneTypeNodes);
            other.closurePrimitiveId = this.closurePrimitiveId;
            other.propertyBitField = this.propertyBitField;
            return other;
        }

        protected ArrayList<JSTypeExpression> cloneTypeList(ArrayList<JSTypeExpression> list, boolean cloneTypeExpressionNodes) {
            ArrayList<JSTypeExpression> newlist = null;
            if (list != null) {
                newlist = new ArrayList<JSTypeExpression>(list.size());
                for (JSTypeExpression expr : list) {
                    newlist.add(JSDocInfo.cloneType(expr, cloneTypeExpressionNodes));
                }
            }
            return newlist;
        }

        protected LinkedHashMap<String, JSTypeExpression> cloneTypeMap(LinkedHashMap<String, JSTypeExpression> map, boolean cloneTypeExpressionNodes) {
            LinkedHashMap<String, JSTypeExpression> newmap = null;
            if (map != null) {
                newmap = new LinkedHashMap<String, JSTypeExpression>();
                for (Map.Entry<String, JSTypeExpression> entry : map.entrySet()) {
                    JSTypeExpression value = entry.getValue();
                    newmap.put(entry.getKey(), JSDocInfo.cloneType(value, cloneTypeExpressionNodes));
                }
            }
            return newmap;
        }

        void setBit(int bitIndex, boolean value) {
            int mask = this.getMaskForBitIndex(bitIndex);
            this.propertyBitField = value ? (this.propertyBitField |= mask) : (this.propertyBitField &= ~mask);
        }

        boolean isBitSet(int bitIndex) {
            int mask = this.getMaskForBitIndex(bitIndex);
            return (mask & this.propertyBitField) != 0;
        }

        private int getMaskForBitIndex(int bitIndex) {
            Preconditions.checkArgument(bitIndex >= 0, "Bit index should be non-negative integer");
            return 1 << bitIndex;
        }
    }

    static class Property {
        static final int NG_INJECT = 0;
        static final int WIZ_ACTION = 1;
        static final int POLYMER_BEHAVIOR = 2;
        static final int POLYMER = 3;
        static final int CUSTOM_ELEMENT = 4;
        static final int MIXIN_CLASS = 5;
        static final int MIXIN_FUNCTION = 6;

        Property() {
        }
    }

    public static enum Visibility {
        PRIVATE,
        PACKAGE,
        PROTECTED,
        PUBLIC,
        INHERITED;

    }
}

