/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.GatherModuleMetadata;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class JsFileFullParser {
    private static final Reporter NULL_REPORTER = new Reporter(){

        @Override
        public void report(boolean fatal, String message, String sourceName, int line, int lineOffset) {
        }
    };

    public static FileInfo parse(String code, String filename, @Nullable Reporter reporter) {
        final DelegatingReporter errorReporter = new DelegatingReporter(reporter);
        Compiler compiler = new Compiler(new BasicErrorManager(){

            @Override
            public void println(CheckLevel level, JSError error) {
                if (level == CheckLevel.ERROR) {
                    errorReporter.error(error.description, error.sourceName, error.getLineNumber(), error.getCharno());
                } else if (level == CheckLevel.WARNING) {
                    errorReporter.warning(error.description, error.sourceName, error.getLineNumber(), error.getCharno());
                }
            }

            @Override
            protected void printSummary() {
            }
        });
        SourceFile source = SourceFile.fromCode(filename, code);
        compiler.init(ImmutableList.of(), ImmutableList.of(source), new CompilerOptions());
        Config config = ParserRunner.createConfig(Config.LanguageMode.ECMASCRIPT8, Config.JsDocParsing.INCLUDE_DESCRIPTIONS_NO_WHITESPACE, Config.RunMode.KEEP_GOING, ImmutableSet.of(), true, Config.StrictMode.SLOPPY);
        FileInfo info = new FileInfo();
        ParserRunner.ParseResult parsed = ParserRunner.parse(source, code, config, errorReporter);
        parsed.ast.setInputId(new InputId(filename));
        String version = parsed.features.version();
        if (!version.equals("es3")) {
            info.loadFlags.put("lang", version);
        }
        for (Comment comment : parsed.comments) {
            if (comment.type != Comment.Type.JSDOC) continue;
            JsFileFullParser.parseComment(comment, info);
        }
        GatherModuleMetadata gatherModuleMetadata = new GatherModuleMetadata(compiler, false, ModuleLoader.ResolutionMode.BROWSER);
        gatherModuleMetadata.process(new Node(Token.ROOT), parsed.ast);
        compiler.generateReport();
        ModuleMetadataMap.ModuleMetadata module = (ModuleMetadataMap.ModuleMetadata)Iterables.getOnlyElement(compiler.getModuleMetadataMap().getModulesByPath().values());
        if (module.isEs6Module()) {
            info.loadFlags.put("module", "es6");
        } else if (module.isGoogModule()) {
            info.loadFlags.put("module", "goog");
        }
        info.goog = module.usesClosure();
        if (module.usesClosure()) {
            info.provides.addAll(module.googNamespaces());
            info.requires.addAll(module.requiredGoogNamespaces());
            info.typeRequires.addAll(module.requiredTypes());
            info.testonly = module.isTestOnly();
        }
        info.importedModules.addAll(module.es6ImportSpecifiers().elementSet());
        return info;
    }

    private static void parseComment(Comment comment, FileInfo info) {
        boolean fileOverview = comment.value.contains("@fileoverview");
        block32: for (CommentAnnotation annotation : CommentAnnotation.parse(comment.value)) {
            switch (annotation.name) {
                case "@fileoverview": 
                case "@author": 
                case "@see": 
                case "@link": {
                    continue block32;
                }
                case "@mods": {
                    if (annotation.value.isEmpty()) continue block32;
                    info.mods.add(annotation.value);
                    continue block32;
                }
                case "@visibility": {
                    if (annotation.value.isEmpty()) continue block32;
                    info.visibility.add(annotation.value);
                    continue block32;
                }
                case "@modName": {
                    if (annotation.value.isEmpty()) continue block32;
                    info.modName.add(annotation.value);
                    continue block32;
                }
                case "@config": {
                    info.isConfig = true;
                    continue block32;
                }
                case "@provideGoog": {
                    info.provideGoog = true;
                    continue block32;
                }
                case "@requirecss": {
                    if (annotation.value.isEmpty()) continue block32;
                    info.requiresCss.add(annotation.value);
                    continue block32;
                }
                case "@hassoydeltemplate": {
                    if (annotation.value.isEmpty()) continue block32;
                    info.hasSoyDeltemplates.add(annotation.value);
                    continue block32;
                }
                case "@hassoydelcall": {
                    if (annotation.value.isEmpty()) continue block32;
                    info.hasSoyDelcalls.add(annotation.value);
                    continue block32;
                }
                case "@externs": {
                    info.isExterns = true;
                    continue block32;
                }
                case "@enhanceable": 
                case "@pintomodule": {
                    info.customAnnotations.put(annotation.name.substring(1), annotation.value);
                    continue block32;
                }
                case "@enhance": {
                    if (annotation.value.isEmpty()) continue block32;
                    info.customAnnotations.put(annotation.name.substring(1), annotation.value);
                    continue block32;
                }
            }
            if (!fileOverview) continue;
            info.customAnnotations.put(annotation.name.substring(1), annotation.value);
        }
    }

    private static final class DelegatingReporter
    implements ErrorReporter {
        final Reporter delegate;

        DelegatingReporter(Reporter delegate) {
            this.delegate = delegate != null ? delegate : NULL_REPORTER;
        }

        @Override
        public void warning(String message, String sourceName, int line, int lineOffset) {
            this.delegate.report(false, message, sourceName, line, lineOffset);
        }

        @Override
        public void error(String message, String sourceName, int line, int lineOffset) {
            this.delegate.report(true, message, sourceName, line, lineOffset);
        }
    }

    public static interface Reporter {
        public void report(boolean var1, String var2, String var3, int var4, int var5);
    }

    private static class CommentAnnotation {
        final String name;
        final String value;
        private static final Pattern ANNOTATION_RE = Pattern.compile("(?:[^a-zA-Z0-9_$]|^)(@[a-zA-Z]+)(?:\\s*\\{\\s*([^}\\t\\n\\v\\f\\r ]+)\\s*\\})?");
        private static final int ANNOTATION_NAME_GROUP = 1;
        private static final int ANNOTATION_VALUE_GROUP = 2;

        CommentAnnotation(String name, String value) {
            this.name = name;
            this.value = value;
        }

        static List<CommentAnnotation> parse(String comment) {
            ArrayList<CommentAnnotation> out = new ArrayList<CommentAnnotation>();
            Matcher matcher = ANNOTATION_RE.matcher(comment);
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = Strings.nullToEmpty(matcher.group(2));
                out.add(new CommentAnnotation(name, value));
            }
            return out;
        }
    }

    public static final class FileInfo {
        public boolean goog = false;
        public boolean isConfig = false;
        public boolean isExterns = false;
        public boolean provideGoog = false;
        public boolean testonly = false;
        public final Set<String> hasSoyDelcalls = new TreeSet<String>();
        public final Set<String> hasSoyDeltemplates = new TreeSet<String>();
        public final Set<String> importedModules = new LinkedHashSet<String>();
        public final List<String> modName = new ArrayList<String>();
        public final List<String> mods = new ArrayList<String>();
        public final Multiset<String> provides = TreeMultiset.create();
        public final Multiset<String> requires = TreeMultiset.create();
        public final Multiset<String> typeRequires = TreeMultiset.create();
        public final Multiset<String> requiresCss = TreeMultiset.create();
        public final Multiset<String> visibility = TreeMultiset.create();
        public final Multimap<String, String> customAnnotations = TreeMultimap.create();
        public final Multimap<String, String> loadFlags = TreeMultimap.create();
    }
}

