/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.DestructuredTarget;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.LinkedFlowScope;
import com.google.javascript.jscomp.ModuleImportResolver;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Promises;
import com.google.javascript.jscomp.ScopedName;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeTransformation;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticTypedSlot;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeReplacer;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

class TypeInference
extends DataFlowAnalysis.BranchedForwardDataFlowAnalysis<Node, FlowScope> {
    static final DiagnosticType FUNCTION_LITERAL_UNDEFINED_THIS = DiagnosticType.warning("JSC_FUNCTION_LITERAL_UNDEFINED_THIS", "Function literal argument refers to undefined this argument");
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private final FlowScope functionScope;
    private final FlowScope bottomScope;
    private final TypedScope containerScope;
    private final TypedScopeCreator scopeCreator;
    private final CodingConvention.AssertionFunctionLookup assertionFunctionLookup;
    private final ModuleImportResolver moduleImportResolver;
    private final Set<TypedScope> inferredUnboundVars = new HashSet<TypedScope>();
    private final ObjectType unknownType;

    TypeInference(AbstractCompiler compiler, ControlFlowGraph<Node> cfg, ReverseAbstractInterpreter reverseInterpreter, TypedScope syntacticScope, TypedScopeCreator scopeCreator, CodingConvention.AssertionFunctionLookup assertionFunctionLookup) {
        super(cfg, new LinkedFlowScope.FlowScopeJoinOp(compiler));
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        this.reverseInterpreter = reverseInterpreter;
        this.unknownType = this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
        this.moduleImportResolver = new ModuleImportResolver(compiler.getModuleMap(), scopeCreator.getNodeToScopeMapper(), this.registry);
        this.containerScope = syntacticScope;
        this.scopeCreator = scopeCreator;
        this.assertionFunctionLookup = assertionFunctionLookup;
        FlowScope entryScope = this.inferDeclarativelyUnboundVarsWithoutTypes(LinkedFlowScope.createEntryLattice(compiler, syntacticScope));
        this.functionScope = this.inferParameters(entryScope);
        this.bottomScope = LinkedFlowScope.createEntryLattice(compiler, TypedScope.createLatticeBottom(syntacticScope.getRootNode()));
    }

    @CheckReturnValue
    private FlowScope inferDeclarativelyUnboundVarsWithoutTypes(FlowScope flow) {
        TypedScope scope = (TypedScope)flow.getDeclarationScope();
        if (!this.inferredUnboundVars.add(scope)) {
            return flow;
        }
        for (TypedVar var : scope.getDeclarativelyUnboundVarsWithoutTypes()) {
            if (this.isUnflowable(var)) continue;
            flow = flow.inferSlotType(var.getName(), this.getNativeType(JSTypeNative.VOID_TYPE));
        }
        return flow;
    }

    private FlowScope inferParameters(FlowScope entryFlowScope) {
        Node functionNode = this.containerScope.getRootNode();
        if (!functionNode.isFunction()) {
            return entryFlowScope;
        }
        if (NodeUtil.isBundledGoogModuleCall(functionNode.getParent())) {
            return entryFlowScope;
        }
        Node astParameters = functionNode.getSecondChild();
        Node iifeArgumentNode = null;
        if (NodeUtil.isInvocationTarget(functionNode)) {
            iifeArgumentNode = functionNode.getNext();
        }
        FunctionType functionType = JSType.toMaybeFunctionType(functionNode.getJSType());
        Node parameterTypeNode = functionType.getParametersNode().getFirstChild();
        for (Node astParameter : astParameters.children()) {
            if (iifeArgumentNode != null && iifeArgumentNode.isSpread()) {
                iifeArgumentNode = null;
            }
            JSType inferredType = this.getJSType(astParameter);
            if (iifeArgumentNode != null) {
                if (iifeArgumentNode.getJSType() != null) {
                    inferredType = iifeArgumentNode.getJSType();
                }
            } else if (parameterTypeNode != null && parameterTypeNode.getJSType() != null) {
                inferredType = parameterTypeNode.getJSType();
            }
            Node defaultValue = null;
            if (astParameter.isDefaultValue()) {
                defaultValue = astParameter.getSecondChild();
                entryFlowScope = this.traverse(defaultValue, entryFlowScope);
                astParameter = astParameter.getFirstChild();
            } else if (astParameter.isRest()) {
                astParameter = astParameter.getOnlyChild();
                inferredType = this.registry.createTemplatizedType(this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE), inferredType);
            }
            if (defaultValue != null) {
                inferredType = this.registry.createUnionType(inferredType.restrictByNotUndefined(), this.getJSType(defaultValue));
            }
            entryFlowScope = astParameter.isDestructuringPattern() ? this.updateDestructuringParameter(astParameter, inferredType, entryFlowScope) : this.updateNamedParameter(astParameter, defaultValue != null, inferredType, entryFlowScope);
            parameterTypeNode = parameterTypeNode != null ? parameterTypeNode.getNext() : null;
            iifeArgumentNode = iifeArgumentNode != null ? iifeArgumentNode.getNext() : null;
        }
        return entryFlowScope;
    }

    @CheckReturnValue
    private FlowScope updateDestructuringParameter(Node pattern, JSType inferredType, FlowScope entryFlowScope) {
        entryFlowScope = this.traverseDestructuringPatternHelper(pattern, entryFlowScope, inferredType, (scope, lvalue, type) -> {
            TypedVar var = this.containerScope.getVar(lvalue.getString());
            Preconditions.checkNotNull(var);
            if (var.isTypeInferred()) {
                var.setType(type);
                lvalue.setJSType(type);
            }
            if (lvalue.getParent().isDefaultValue()) {
                scope = this.updateScopeForAssignment(scope, lvalue, type, AssignmentType.ASSIGN);
            }
            return scope;
        });
        return entryFlowScope;
    }

    @CheckReturnValue
    private FlowScope updateNamedParameter(Node paramName, boolean hasDefaultValue, JSType inferredType, FlowScope entryFlowScope) {
        TypedVar var = this.containerScope.getVar(paramName.getString());
        Preconditions.checkNotNull(var, "Missing var for parameter %s", (Object)paramName);
        paramName.setJSType(inferredType);
        if (var.isTypeInferred()) {
            var.setType(inferredType);
        } else if (hasDefaultValue) {
            entryFlowScope = this.redeclareSimpleVar(entryFlowScope, paramName, inferredType);
        }
        return entryFlowScope;
    }

    @Override
    FlowScope createInitialEstimateLattice() {
        return this.bottomScope;
    }

    @Override
    FlowScope createEntryLattice() {
        return this.functionScope;
    }

    @Override
    @CheckReturnValue
    FlowScope flowThrough(Node n, FlowScope input) {
        if (input == this.bottomScope) {
            return input;
        }
        Node root = NodeUtil.getEnclosingScopeRoot(n);
        Module module = ModuleImportResolver.getModuleFromScopeRoot(this.compiler.getModuleMap(), this.compiler, root);
        TypedScope syntacticBlockScope = this.scopeCreator.createScope(root);
        if (module != null && module.metadata().isEs6Module()) {
            this.moduleImportResolver.declareEsModuleImports(module, syntacticBlockScope, this.compiler.getInput(NodeUtil.getInputId(n)));
        }
        FlowScope output = input.withSyntacticScope(syntacticBlockScope);
        output = this.inferDeclarativelyUnboundVarsWithoutTypes(output);
        output = this.traverse(n, output);
        if (module != null && module.metadata().isEs6Module()) {
            this.moduleImportResolver.updateEsModuleNamespaceType(syntacticBlockScope.getVar("*exports*").getType().toObjectType(), module, syntacticBlockScope);
        }
        return output;
    }

    @Override
    List<FlowScope> branchedFlowThrough(Node source, FlowScope input) {
        FlowScope output = this.flowThrough(source, input);
        Node condition = null;
        FlowScope conditionFlowScope = null;
        BooleanOutcomePair conditionOutcomes = null;
        List branchEdges = this.getCfg().getOutEdges(source);
        ArrayList<FlowScope> result = new ArrayList<FlowScope>(branchEdges.size());
        for (DiGraph.DiGraphEdge branchEdge : branchEdges) {
            ControlFlowGraph.Branch branch = (ControlFlowGraph.Branch)((Object)branchEdge.getValue());
            FlowScope newScope = output;
            switch (branch) {
                case ON_TRUE: {
                    if (source.isForIn() || source.isForOf()) {
                        AssignmentType assignmentType;
                        Node item = source.getFirstChild();
                        Node obj = item.getNext();
                        FlowScope informed = this.traverse(obj, output);
                        if (NodeUtil.isNameDeclaration(item)) {
                            item = item.getFirstChild();
                            assignmentType = AssignmentType.DECLARATION;
                        } else {
                            assignmentType = AssignmentType.ASSIGN;
                        }
                        if (item.isDestructuringLhs()) {
                            item = item.getFirstChild();
                        }
                        if (source.isForIn()) {
                            JSType narrowedKeyType;
                            JSType iterKeyType = this.getNativeType(JSTypeNative.STRING_TYPE);
                            JSType objType = this.getJSType(obj).autobox();
                            JSType objIndexType = objType.getTemplateTypeMap().getResolvedTemplateType(this.registry.getObjectIndexKey());
                            if (objIndexType != null && !objIndexType.isUnknownType() && !(narrowedKeyType = iterKeyType.getGreatestSubtype(objIndexType)).isEmptyType()) {
                                iterKeyType = narrowedKeyType;
                            }
                            if (item.isName()) {
                                informed = this.redeclareSimpleVar(informed, item, iterKeyType);
                            } else if (item.isDestructuringPattern()) {
                                informed = this.traverseDestructuringPattern(item, informed, iterKeyType, assignmentType);
                            }
                        } else {
                            JSType objType = this.getJSType(obj).autobox();
                            JSType newType = objType.getInstantiatedTypeArgument(this.getNativeType(JSTypeNative.ITERABLE_TYPE));
                            if (item.isDestructuringPattern()) {
                                informed = this.traverseDestructuringPattern(item, informed, newType, assignmentType);
                            } else {
                                informed = this.traverse(item, informed);
                                informed = this.updateScopeForAssignment(informed, item, newType, assignmentType);
                            }
                        }
                        newScope = informed;
                        break;
                    }
                }
                case ON_FALSE: {
                    if (condition == null && (condition = NodeUtil.getConditionExpression(source)) == null && source.isCase()) {
                        condition = source;
                        if (conditionFlowScope == null) {
                            conditionFlowScope = this.traverse(condition.getFirstChild(), output);
                        }
                    }
                    if (condition == null) break;
                    if (condition.isAnd() || condition.isOr()) {
                        if (conditionOutcomes == null) {
                            conditionOutcomes = condition.isAnd() ? this.traverseAnd(condition, output) : this.traverseOr(condition, output);
                        }
                        newScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, conditionOutcomes.getOutcomeFlowScope(condition.getToken(), branch == ControlFlowGraph.Branch.ON_TRUE), branch == ControlFlowGraph.Branch.ON_TRUE);
                        break;
                    }
                    if (conditionFlowScope == null) {
                        conditionFlowScope = this.traverse(condition, output);
                    }
                    newScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, conditionFlowScope, branch == ControlFlowGraph.Branch.ON_TRUE);
                    break;
                }
            }
            result.add(newScope);
        }
        return result;
    }

    private FlowScope traverse(Node n, FlowScope scope) {
        switch (n.getToken()) {
            case ASSIGN: {
                scope = this.traverseAssign(n, scope);
                break;
            }
            case NAME: {
                scope = this.traverseName(n, scope);
                break;
            }
            case GETPROP: {
                scope = this.traverseGetProp(n, scope);
                break;
            }
            case CLASS: {
                scope = this.traverseClass(n, scope);
                break;
            }
            case AND: {
                scope = this.traverseAnd(n, scope).getJoinedFlowScope();
                break;
            }
            case OR: {
                scope = this.traverseOr(n, scope).getJoinedFlowScope();
                break;
            }
            case HOOK: {
                scope = this.traverseHook(n, scope);
                break;
            }
            case OBJECTLIT: {
                scope = this.traverseObjectLiteral(n, scope);
                break;
            }
            case CALL: {
                scope = this.traverseFunctionInvocation(n, scope);
                scope = this.tightenTypesAfterAssertions(scope, n);
                break;
            }
            case NEW: {
                scope = this.traverseNew(n, scope);
                break;
            }
            case NEW_TARGET: {
                this.traverseNewTarget(n);
                break;
            }
            case ASSIGN_ADD: 
            case ADD: {
                scope = this.traverseAdd(n, scope);
                break;
            }
            case POS: 
            case NEG: {
                scope = this.traverse(n.getFirstChild(), scope);
                n.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
                break;
            }
            case ARRAYLIT: {
                scope = this.traverseArrayLiteral(n, scope);
                break;
            }
            case THIS: {
                n.setJSType(scope.getTypeOfThis());
                break;
            }
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_BITAND: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITOR: 
            case ASSIGN_MUL: 
            case ASSIGN_SUB: 
            case ASSIGN_EXPONENT: {
                scope = this.traverseAssignOp(n, scope, this.getNativeType(JSTypeNative.NUMBER_TYPE));
                break;
            }
            case LSH: 
            case RSH: 
            case URSH: 
            case DIV: 
            case MOD: 
            case BITAND: 
            case BITXOR: 
            case BITOR: 
            case MUL: 
            case SUB: 
            case DEC: 
            case INC: 
            case BITNOT: 
            case EXPONENT: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
                break;
            }
            case COMMA: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getJSType(n.getLastChild()));
                break;
            }
            case TEMPLATELIT: 
            case TYPEOF: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.STRING_TYPE));
                break;
            }
            case TEMPLATELIT_SUB: {
                scope = this.traverseChildren(n, scope);
                break;
            }
            case TAGGED_TEMPLATELIT: {
                scope = this.traverseFunctionInvocation(n, scope);
                break;
            }
            case DELPROP: 
            case LT: 
            case LE: 
            case GT: 
            case GE: 
            case NOT: 
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: 
            case INSTANCEOF: 
            case IN: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                break;
            }
            case GETELEM: {
                scope = this.traverseGetElem(n, scope);
                break;
            }
            case EXPR_RESULT: {
                Node getprop;
                ObjectType ownerType;
                scope = this.traverseChildren(n, scope);
                if (!n.getFirstChild().isGetProp() || (ownerType = ObjectType.cast(this.getJSType((getprop = n.getFirstChild()).getFirstChild()).restrictByNotNullOrUndefined())) == null) break;
                this.ensurePropertyDeclaredHelper(getprop, ownerType, scope);
                break;
            }
            case SWITCH: {
                scope = this.traverse(n.getFirstChild(), scope);
                break;
            }
            case RETURN: {
                scope = this.traverseReturn(n, scope);
                break;
            }
            case YIELD: {
                scope = this.traverseChildren(n, scope);
                n.setJSType(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                scope = this.traverseDeclaration(n, scope);
                break;
            }
            case THROW: {
                scope = this.traverseChildren(n, scope);
                break;
            }
            case CATCH: {
                scope = this.traverseCatch(n, scope);
                break;
            }
            case CAST: {
                scope = this.traverseChildren(n, scope);
                JSDocInfo info = n.getJSDocInfo();
                Preconditions.checkNotNull(info, "CAST node should always have JSDocInfo");
                if (info.hasType()) {
                    n.setJSType(info.getType().evaluate(scope.getDeclarationScope(), this.registry).resolve(this.registry.getErrorReporter()));
                    break;
                }
                n.setJSType(this.unknownType);
                break;
            }
            case SUPER: {
                this.traverseSuper(n);
                break;
            }
            case ITER_SPREAD: 
            case OBJECT_SPREAD: {
                scope = this.traverseChildren(n, scope);
                break;
            }
            case AWAIT: {
                scope = this.traverseAwait(n, scope);
                break;
            }
            case VOID: {
                n.setJSType(this.getNativeType(JSTypeNative.VOID_TYPE));
                scope = this.traverseChildren(n, scope);
                break;
            }
            case EXPORT: {
                TypedVar defaultExport;
                scope = this.traverseChildren(n, scope);
                if (!n.getBooleanProp(Node.EXPORT_DEFAULT) || !(defaultExport = TypeInference.getDeclaredVar(scope, "*default*")).isTypeInferred()) break;
                defaultExport.setType(this.getJSType(n.getOnlyChild()));
                break;
            }
            case IMPORT_META: {
                n.setJSType(this.unknownType);
                break;
            }
            case ROOT: 
            case SCRIPT: 
            case MODULE_BODY: 
            case FUNCTION: 
            case PARAM_LIST: 
            case BLOCK: 
            case EMPTY: 
            case IF: 
            case WHILE: 
            case DO: 
            case FOR: 
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: 
            case BREAK: 
            case CONTINUE: 
            case TRY: 
            case CASE: 
            case DEFAULT_CASE: 
            case WITH: 
            case DEBUGGER: 
            case IMPORT: 
            case IMPORT_SPEC: 
            case IMPORT_SPECS: 
            case EXPORT_SPECS: {
                break;
            }
            case TRUE: 
            case FALSE: 
            case STRING: 
            case NUMBER: 
            case NULL: 
            case REGEXP: 
            case TEMPLATELIT_STRING: {
                break;
            }
            default: {
                throw new IllegalStateException("Type inference doesn't know to handle token " + (Object)((Object)n.getToken()));
            }
        }
        return scope;
    }

    private void traverseSuper(Node superNode) {
        TypedScope scope;
        for (scope = this.containerScope; scope != null && !NodeUtil.isNonArrowFunction(scope.getRootNode()); scope = scope.getParent()) {
        }
        if (scope == null) {
            superNode.setJSType(this.unknownType);
            return;
        }
        FunctionType enclosingFunctionType = JSType.toMaybeFunctionType(scope.getRootNode().getJSType());
        ObjectType superNodeType = null;
        switch (superNode.getParent().getToken()) {
            case CALL: {
                if (enclosingFunctionType == null || !enclosingFunctionType.isConstructor()) break;
                superNodeType = enclosingFunctionType.getSuperClassConstructor();
                break;
            }
            case GETPROP: 
            case GETELEM: {
                superNodeType = ObjectType.cast(this.functionScope.getSlot("super").getType());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected parent of SUPER: " + superNode.getParent().toStringTree());
            }
        }
        superNode.setJSType(superNodeType != null ? superNodeType : this.unknownType);
    }

    private void traverseNewTarget(Node newTargetNode) {
        TypedScope scope;
        for (scope = this.containerScope; scope != null && !NodeUtil.isNonArrowFunction(scope.getRootNode()); scope = scope.getParent()) {
        }
        if (scope == null) {
            newTargetNode.setJSType(this.unknownType);
            return;
        }
        Node root = scope.getRootNode();
        Node parent = root.getParent();
        if (parent.getGrandparent().isClass()) {
            JSTypeNative type = NodeUtil.isEs6ConstructorMemberFunctionDef(parent) ? JSTypeNative.U2U_CONSTRUCTOR_TYPE : JSTypeNative.VOID_TYPE;
            newTargetNode.setJSType(this.registry.getNativeType(type));
        } else {
            newTargetNode.setJSType(this.registry.createUnionType(this.registry.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE), this.registry.getNativeType(JSTypeNative.VOID_TYPE)));
        }
    }

    @CheckReturnValue
    private FlowScope traverseReturn(Node n, FlowScope scope) {
        FunctionType fnType;
        JSType type;
        scope = this.traverseChildren(n, scope);
        Node retValue = n.getFirstChild();
        if (retValue != null && (type = this.functionScope.getRootNode().getJSType()) != null && (fnType = type.toMaybeFunctionType()) != null) {
            TypeInference.inferPropertyTypesToMatchConstraint(retValue.getJSType(), fnType.getReturnType());
        }
        return scope;
    }

    @CheckReturnValue
    private FlowScope traverseCatch(Node catchNode, FlowScope scope) {
        Node catchTarget = catchNode.getFirstChild();
        if (catchTarget.isName()) {
            Node name = catchNode.getFirstChild();
            JSDocInfo info = name.getJSDocInfo();
            JSType type = info != null && info.hasType() ? info.getType().evaluate(scope.getDeclarationScope(), this.registry) : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            name.setJSType(type);
            return this.redeclareSimpleVar(scope, name, type);
        }
        if (catchTarget.isDestructuringPattern()) {
            Node pattern = catchNode.getFirstChild();
            return this.traverseDestructuringPattern(pattern, scope, this.unknownType, AssignmentType.DECLARATION);
        }
        Preconditions.checkState(catchTarget.isEmpty(), catchTarget);
        return scope;
    }

    @CheckReturnValue
    private FlowScope traverseAssign(Node n, FlowScope scope) {
        Node target = n.getFirstChild();
        Node value = n.getLastChild();
        if (target.isDestructuringPattern()) {
            scope = this.traverse(value, scope);
            JSType valueType = this.getJSType(value);
            n.setJSType(valueType);
            return this.traverseDestructuringPattern(target, scope, valueType, AssignmentType.ASSIGN);
        }
        scope = this.traverseChildren(n, scope);
        JSType valueType = this.getJSType(value);
        n.setJSType(valueType);
        return this.updateScopeForAssignment(scope, target, valueType, AssignmentType.ASSIGN);
    }

    @CheckReturnValue
    private FlowScope traverseAssignOp(Node n, FlowScope scope, JSType resultType) {
        Node left = n.getFirstChild();
        scope = this.traverseChildren(n, scope);
        n.setJSType(resultType);
        return this.updateScopeForAssignment(scope, left, resultType, null, AssignmentType.ASSIGN);
    }

    private static boolean isInExternFile(Node n) {
        return NodeUtil.getSourceFile(n).isExtern();
    }

    private static boolean isPossibleMixinApplication(Node lvalue, Node rvalue) {
        if (TypeInference.isInExternFile(lvalue)) {
            return true;
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(lvalue);
        return jsdoc != null && jsdoc.isConstructor() && jsdoc.getImplementedInterfaceCount() > 0 && lvalue.isQualifiedName() && rvalue.isCall();
    }

    private static void addMissingInterfaceProperties(JSType constructor) {
        if (constructor != null && constructor.isConstructor()) {
            FunctionType f = constructor.toMaybeFunctionType();
            ObjectType proto = f.getPrototype();
            for (ObjectType interf : f.getImplementedInterfaces()) {
                for (String pname : interf.getPropertyNames()) {
                    if (proto.hasProperty(pname)) continue;
                    proto.defineDeclaredProperty(pname, interf.getPropertyType(pname), null);
                }
            }
        }
    }

    @CheckReturnValue
    private FlowScope updateScopeForAssignment(FlowScope scope, Node target, JSType resultType, AssignmentType type) {
        return this.updateScopeForAssignment(scope, target, resultType, target, type);
    }

    @CheckReturnValue
    private FlowScope updateScopeForAssignment(FlowScope scope, Node target, JSType resultType, Node updateNode, AssignmentType type) {
        Preconditions.checkNotNull(resultType);
        Preconditions.checkState(updateNode == null || updateNode == target);
        JSType targetType = target.getJSType();
        Node right = NodeUtil.getRValueOfLValue(target);
        if (TypeInference.isPossibleMixinApplication(target, right)) {
            TypeInference.addMissingInterfaceProperties(targetType);
        }
        switch (target.getToken()) {
            case NAME: {
                String varName = target.getString();
                TypedVar var = TypeInference.getDeclaredVar(scope, varName);
                JSType varType = var == null ? null : var.getType();
                boolean isVarDeclaration = type == AssignmentType.DECLARATION && varType != null && !var.isTypeInferred() && var.getNameNode() != null;
                boolean isTypelessConstDecl = isVarDeclaration && NodeUtil.isConstantDeclaration(this.compiler.getCodingConvention(), var.getJSDocInfo(), var.getNameNode()) && (var.getJSDocInfo() == null || !var.getJSDocInfo().containsDeclarationExcludingTypelessConst());
                boolean isVarTypeBetter = isVarDeclaration && !resultType.isNullType() && !resultType.isVoidType() && !isTypelessConstDecl;
                scope = isVarTypeBetter ? this.redeclareSimpleVar(scope, target, varType) : this.redeclareSimpleVar(scope, target, resultType);
                if (updateNode != null) {
                    updateNode.setJSType(resultType);
                }
                if (var != null && var.isTypeInferred() && (!target.getParent().isLet() || target.hasChildren())) {
                    JSType oldType = var.getType();
                    var.setType(oldType == null ? resultType : oldType.getLeastSupertype(resultType));
                    break;
                }
                if (!isTypelessConstDecl) break;
                var.setType(resultType);
                break;
            }
            case GETPROP: {
                if (target.isQualifiedName()) {
                    ObjectType objType;
                    String qualifiedName = target.getQualifiedName();
                    boolean declaredSlotType = false;
                    JSType rawObjType = target.getFirstChild().getJSType();
                    if (rawObjType != null && (objType = ObjectType.cast(rawObjType.restrictByNotNullOrUndefined())) != null) {
                        String propName = target.getLastChild().getString();
                        declaredSlotType = objType.isPropertyTypeDeclared(propName);
                    }
                    JSType safeLeftType = targetType == null ? this.unknownType : targetType;
                    scope = scope.inferQualifiedSlot(target, qualifiedName, safeLeftType, resultType, declaredSlotType);
                }
                if (updateNode != null) {
                    updateNode.setJSType(resultType);
                }
                this.ensurePropertyDefined(target, resultType, scope);
                break;
            }
        }
        return scope;
    }

    private void ensurePropertyDefined(Node getprop, JSType rightType, FlowScope scope) {
        boolean propCreationInConstructor;
        String propName = getprop.getLastChild().getString();
        Node obj = getprop.getFirstChild();
        JSType nodeType = this.getJSType(obj);
        ObjectType objectType = ObjectType.cast(nodeType.restrictByNotNullOrUndefined());
        boolean bl = propCreationInConstructor = obj.isThis() && this.getJSType(this.containerScope.getRootNode()).isConstructor();
        if (objectType == null) {
            this.registry.registerPropertyOnType(propName, nodeType);
        } else {
            if (nodeType.isStruct() && !objectType.hasProperty(propName)) {
                boolean staticPropCreation = false;
                Node maybeAssignStm = getprop.getGrandparent();
                if (this.containerScope.isGlobal() && NodeUtil.isPrototypePropertyDeclaration(maybeAssignStm)) {
                    String propCreationFilename = maybeAssignStm.getSourceFileName();
                    Node ctor = objectType.getOwnerFunction().getSource();
                    if (ctor != null && ctor.getSourceFileName().equals(propCreationFilename)) {
                        staticPropCreation = true;
                    }
                }
                if (!propCreationInConstructor && !staticPropCreation) {
                    return;
                }
            }
            if (this.ensurePropertyDeclaredHelper(getprop, objectType, scope)) {
                return;
            }
            if (!objectType.isPropertyTypeDeclared(propName)) {
                if (objectType.hasProperty(propName) || !objectType.isInstanceType()) {
                    if ("prototype".equals(propName)) {
                        objectType.defineDeclaredProperty(propName, rightType, getprop);
                    } else {
                        objectType.defineInferredProperty(propName, rightType, getprop);
                    }
                } else if (propCreationInConstructor) {
                    objectType.defineInferredProperty(propName, rightType, getprop);
                } else {
                    this.registry.registerPropertyOnType(propName, objectType);
                }
            }
        }
    }

    private boolean ensurePropertyDeclaredHelper(Node getprop, ObjectType objectType, FlowScope scope) {
        if (getprop.isQualifiedName()) {
            String propName = getprop.getLastChild().getString();
            String qName = getprop.getQualifiedName();
            TypedVar var = TypeInference.getDeclaredVar(scope, qName);
            if (var != null && !var.isTypeInferred() && (propName.equals("prototype") || !objectType.hasOwnProperty(propName) && (!objectType.isInstanceType() || var.isExtern() && !objectType.isNativeObjectType()))) {
                return objectType.defineDeclaredProperty(propName, var.getType(), getprop);
            }
        }
        return false;
    }

    private FlowScope traverseDeclaration(Node n, FlowScope scope) {
        for (Node declarationChild : n.children()) {
            scope = this.traverseDeclarationChild(declarationChild, scope);
        }
        return scope;
    }

    private FlowScope traverseDeclarationChild(Node n, FlowScope scope) {
        if (n.isName()) {
            return this.traverseName(n, scope);
        }
        Preconditions.checkState(n.isDestructuringLhs(), n);
        scope = this.traverse(n.getSecondChild(), scope);
        return this.traverseDestructuringPattern(n.getFirstChild(), scope, this.getJSType(n.getSecondChild()), AssignmentType.DECLARATION);
    }

    private FlowScope traverseDestructuringPattern(Node pattern, FlowScope scope, JSType patternType, AssignmentType assignmentType) {
        return this.traverseDestructuringPatternHelper(pattern, scope, patternType, (flowScope, targetNode, targetType) -> {
            targetType = targetType != null ? targetType : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            return this.updateScopeForAssignment(flowScope, targetNode, targetType, assignmentType);
        });
    }

    private FlowScope traverseDestructuringPatternHelper(Node pattern, FlowScope scope, JSType patternType, TypeDeclaringCallback declarer) {
        Preconditions.checkArgument(pattern.isDestructuringPattern(), pattern);
        Preconditions.checkNotNull(patternType);
        for (DestructuredTarget target : DestructuredTarget.createAllNonEmptyTargetsInPattern(this.registry, patternType, pattern)) {
            Node targetNode;
            if (target.hasComputedProperty()) {
                scope = this.traverse(target.getComputedProperty().getFirstChild(), scope);
            }
            if ((targetNode = target.getNode()).isDestructuringPattern()) {
                JSType targetType;
                if (target.hasDefaultValue()) {
                    this.traverse(target.getDefaultValue(), scope);
                }
                targetType = (targetType = target.inferType()) != null ? targetType : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                scope = this.traverseDestructuringPatternHelper(targetNode, scope, targetType, declarer);
                continue;
            }
            scope = this.traverse(targetNode, scope);
            if (target.hasDefaultValue()) {
                this.traverse(target.getDefaultValue(), scope);
            }
            scope = declarer.declareTypeInScope(scope, targetNode, target.inferType());
        }
        pattern.setJSType(patternType);
        return scope;
    }

    private FlowScope traverseName(Node n, FlowScope scope) {
        String varName = n.getString();
        Node value = n.getFirstChild();
        JSType type = n.getJSType();
        if (value != null) {
            scope = this.traverse(value, scope);
            return this.updateScopeForAssignment(scope, n, this.getJSType(value), AssignmentType.DECLARATION);
        }
        if (n.getParent().isLet()) {
            JSType resultType = type != null ? type : this.getNativeType(JSTypeNative.VOID_TYPE);
            scope = this.updateScopeForAssignment(scope, n, resultType, AssignmentType.DECLARATION);
            type = resultType;
        } else {
            StaticTypedSlot var = scope.getSlot(varName);
            if (var != null) {
                boolean nonLocalInferredSlot;
                boolean isInferred = var.isTypeInferred();
                boolean unflowable = isInferred && this.isUnflowable(TypeInference.getDeclaredVar(scope, varName));
                TypedVar maybeOuterVar = isInferred && this.containerScope.isLocal() ? this.containerScope.getParent().getVar(varName) : null;
                boolean bl = nonLocalInferredSlot = var.equals(maybeOuterVar) && !maybeOuterVar.isMarkedAssignedExactlyOnce();
                if (!unflowable && !nonLocalInferredSlot && (type = var.getType()) == null) {
                    type = this.unknownType;
                }
            }
        }
        n.setJSType(type);
        return scope;
    }

    private FlowScope traverseClass(Node n, FlowScope scope) {
        scope = this.traverse(n.getSecondChild(), scope);
        Node classMembers = NodeUtil.getClassMembers(n);
        for (Node member = classMembers.getFirstChild(); member != null; member = member.getNext()) {
            if (!member.isComputedProp()) continue;
            scope = this.traverse(member.getFirstChild(), scope);
        }
        return scope;
    }

    private FlowScope traverseArrayLiteral(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        n.setJSType(this.registry.createTemplatizedType(this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE), this.getNativeType(JSTypeNative.UNKNOWN_TYPE)));
        return scope;
    }

    private FlowScope traverseObjectLiteral(Node n, FlowScope scope) {
        JSType type = n.getJSType();
        Preconditions.checkNotNull(type);
        for (Node name = n.getFirstChild(); name != null; name = name.getNext()) {
            scope = this.traverseChildren(name, scope);
        }
        ObjectType objectType = ObjectType.cast(type);
        if (objectType == null || n.getBooleanProp(Node.REFLECTED_OBJECT) || objectType.isEnumType()) {
            return scope;
        }
        String qObjName = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(n));
        for (Node key = n.getFirstChild(); key != null; key = key.getNext()) {
            if (key.isComputedProp()) continue;
            if (key.isSpread()) {
                n.setJSType(this.registry.getNativeType(JSTypeNative.OBJECT_TYPE));
                break;
            }
            String memberName = NodeUtil.getObjectLitKeyName(key);
            if (memberName != null) {
                JSType oldType;
                JSType rawValueType = key.getFirstChild().getJSType();
                JSType valueType = TypeCheck.getObjectLitKeyTypeFromValueType(key, rawValueType);
                if (valueType == null) {
                    valueType = this.unknownType;
                }
                objectType.defineInferredProperty(memberName, valueType, key);
                if (qObjName == null || !key.isStringKey()) continue;
                String qKeyName = qObjName + "." + memberName;
                TypedVar var = TypeInference.getDeclaredVar(scope, qKeyName);
                JSType jSType = oldType = var == null ? null : var.getType();
                if (var != null && var.isTypeInferred()) {
                    var.setType(oldType == null ? valueType : oldType.getLeastSupertype(oldType));
                }
                scope = scope.inferQualifiedSlot(key, qKeyName, oldType == null ? this.unknownType : oldType, valueType, false);
                continue;
            }
            n.setJSType(this.unknownType);
        }
        return scope;
    }

    private FlowScope traverseAdd(Node n, FlowScope scope) {
        Node left = n.getFirstChild();
        Node right = left.getNext();
        scope = this.traverseChildren(n, scope);
        JSType leftType = left.getJSType();
        JSType rightType = right.getJSType();
        JSType type = this.unknownType;
        if (leftType != null && rightType != null) {
            boolean leftIsUnknown = leftType.isUnknownType();
            boolean rightIsUnknown = rightType.isUnknownType();
            type = leftIsUnknown && rightIsUnknown ? this.unknownType : (!leftIsUnknown && leftType.isString() || !rightIsUnknown && rightType.isString() ? this.getNativeType(JSTypeNative.STRING_TYPE) : (leftIsUnknown || rightIsUnknown ? this.unknownType : (this.isAddedAsNumber(leftType) && this.isAddedAsNumber(rightType) ? this.getNativeType(JSTypeNative.NUMBER_TYPE) : this.registry.createUnionType(JSTypeNative.STRING_TYPE, JSTypeNative.NUMBER_TYPE))));
        }
        n.setJSType(type);
        if (n.isAssignAdd()) {
            scope = this.updateScopeForAssignment(scope, left, type, AssignmentType.ASSIGN);
        }
        return scope;
    }

    private boolean isAddedAsNumber(JSType type) {
        return type.isSubtypeOf(this.registry.createUnionType(JSTypeNative.VOID_TYPE, JSTypeNative.NULL_TYPE, JSTypeNative.NUMBER_TYPE, JSTypeNative.NUMBER_OBJECT_TYPE, JSTypeNative.BOOLEAN_TYPE, JSTypeNative.BOOLEAN_OBJECT_TYPE));
    }

    private FlowScope traverseHook(Node n, FlowScope scope) {
        Node condition = n.getFirstChild();
        Node trueNode = condition.getNext();
        Node falseNode = n.getLastChild();
        scope = this.traverse(condition, scope);
        FlowScope trueScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, scope, true);
        FlowScope falseScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(condition, scope, false);
        this.traverse(trueNode, trueScope);
        this.traverse(falseNode, falseScope);
        JSType trueType = trueNode.getJSType();
        JSType falseType = falseNode.getJSType();
        if (trueType != null && falseType != null) {
            n.setJSType(trueType.getLeastSupertype(falseType));
        } else {
            n.setJSType(null);
        }
        return scope;
    }

    private FlowScope traverseFunctionInvocation(Node n, FlowScope scope) {
        Preconditions.checkArgument(n.isCall() || n.isTaggedTemplateLit(), n);
        scope = this.traverseChildren(n, scope);
        if (n.isCall() && !n.getParent().isExprResult() && ModuleImportResolver.isGoogModuleDependencyCall(n)) {
            ScopedName name = this.moduleImportResolver.getClosureNamespaceTypeFromCall(n);
            if (name != null) {
                TypedScope otherModuleScope = this.scopeCreator.getNodeToScopeMapper().apply(name.getScopeRoot());
                TypedVar otherVar = otherModuleScope != null ? (TypedVar)otherModuleScope.getSlot(name.getName()) : null;
                n.setJSType(otherVar != null ? otherVar.getType() : this.unknownType);
            } else {
                n.setJSType(this.unknownType);
            }
            return scope;
        }
        Node left = n.getFirstChild();
        JSType functionType = this.getJSType(left).restrictByNotNullOrUndefined();
        if (left.isSuper()) {
            return this.traverseInstantiation(n, functionType, scope);
        }
        if (functionType.isFunctionType()) {
            FunctionType fnType = functionType.toMaybeFunctionType();
            n.setJSType(fnType.getReturnType());
            this.backwardsInferenceFromCallSite(n, fnType, scope);
        } else if (functionType.isEquivalentTo(this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE))) {
            n.setJSType(this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE));
        } else if (left.getJSType() != null && left.getJSType().isUnknownType()) {
            n.setJSType(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
        }
        return scope;
    }

    private FlowScope tightenTypesAfterAssertions(FlowScope scope, Node callNode) {
        Node left = callNode.getFirstChild();
        Node firstParam = left.getNext();
        if (firstParam == null) {
            return scope;
        }
        CodingConvention.AssertionFunctionSpec assertionFunctionSpec = this.assertionFunctionLookup.lookupByCallee(left);
        if (assertionFunctionSpec == null) {
            return scope;
        }
        Node assertedNode = assertionFunctionSpec.getAssertedArg(firstParam);
        if (assertedNode == null) {
            return scope;
        }
        String assertedNodeName = assertedNode.getQualifiedName();
        switch (assertionFunctionSpec.getAssertionKind()) {
            case TRUTHY: {
                scope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(assertedNode, scope, true);
                JSType truthyType = this.getJSType(assertedNode).restrictByNotNullOrUndefined();
                callNode.setJSType(truthyType);
                break;
            }
            case MATCHES_RETURN_TYPE: {
                FunctionType callType = JSType.toMaybeFunctionType(left.getJSType());
                JSType assertedType = callType != null ? callType.getReturnType() : this.unknownType;
                JSType type = this.getJSType(assertedNode);
                JSType narrowed = assertedType.isUnknownType() || type.isUnknownType() ? assertedType : type.getGreatestSubtype(assertedType);
                callNode.setJSType(narrowed);
                if (assertedNodeName == null || !type.differsFrom(narrowed)) break;
                scope = this.narrowScope(scope, assertedNode, narrowed);
            }
        }
        return scope;
    }

    private FlowScope narrowScope(FlowScope scope, Node node, JSType narrowed) {
        if (node.isThis()) {
            return scope;
        }
        if (node.isGetProp()) {
            return scope.inferQualifiedSlot(node, node.getQualifiedName(), this.getJSType(node), narrowed, false);
        }
        return this.redeclareSimpleVar(scope, node, narrowed);
    }

    private void backwardsInferenceFromCallSite(Node n, FunctionType fnType, FlowScope scope) {
        boolean updatedFnType = this.inferTemplatedTypesForCall(n, fnType, scope);
        if (updatedFnType) {
            fnType = n.getFirstChild().getJSType().toMaybeFunctionType();
        }
        this.updateTypeOfArguments(n, fnType);
        this.updateBind(n);
    }

    private void updateBind(Node n) {
        JSType thisType;
        CodingConvention.Bind bind = this.compiler.getCodingConvention().describeFunctionBind(n, false, true);
        if (bind == null) {
            return;
        }
        Node target = bind.target;
        FunctionType callTargetFn = this.getJSType(target).restrictByNotNullOrUndefined().toMaybeFunctionType();
        if (callTargetFn == null) {
            return;
        }
        if (bind.thisValue != null && target.isFunction() && (thisType = this.getJSType(bind.thisValue)).toObjectType() != null && !thisType.isUnknownType() && callTargetFn.getTypeOfThis().isUnknownType()) {
            callTargetFn = FunctionType.builder(this.registry).copyFromOtherFunction(callTargetFn).withTypeOfThis(thisType.toObjectType()).build();
            target.setJSType(callTargetFn);
        }
        n.setJSType(callTargetFn.getBindReturnType(bind.getBoundParameterCount() + 1));
    }

    private void updateTypeOfArguments(Node n, FunctionType fnType) {
        Preconditions.checkState(NodeUtil.isInvocation(n), n);
        Iterator<Node> parameters = fnType.getParameters().iterator();
        if (n.isTaggedTemplateLit()) {
            if (!parameters.hasNext()) {
                return;
            }
            parameters.next();
        }
        Iterator<Node> arguments = NodeUtil.getInvocationArgsAsIterable(n).iterator();
        while (parameters.hasNext() && arguments.hasNext()) {
            Node iArgument = arguments.next();
            JSType iArgumentType = this.getJSType(iArgument);
            Node iParameter = parameters.next();
            JSType iParameterType = this.getJSType(iParameter);
            TypeInference.inferPropertyTypesToMatchConstraint(iArgumentType, iParameterType);
            FunctionType restrictedParameter = null;
            if (iParameterType.isUnionType()) {
                UnionType union = iParameterType.toMaybeUnionType();
                for (JSType alternative : union.getAlternates()) {
                    if (!alternative.isFunctionType()) continue;
                    restrictedParameter = alternative.toMaybeFunctionType();
                    break;
                }
            } else {
                restrictedParameter = iParameterType.toMaybeFunctionType();
            }
            if (restrictedParameter == null || !iArgument.isFunction() || !iArgumentType.isFunctionType()) continue;
            FunctionType argFnType = iArgumentType.toMaybeFunctionType();
            JSDocInfo argJsdoc = iArgument.getJSDocInfo();
            boolean declared = argJsdoc != null && argJsdoc.containsDeclaration() || NodeUtil.functionHasInlineJsdocs(iArgument);
            iArgument.setJSType(this.matchFunction(restrictedParameter, argFnType, declared));
        }
    }

    private FunctionType matchFunction(FunctionType expectedType, FunctionType currentType, boolean declared) {
        if (declared) {
            if (currentType.getTypeOfThis().isUnknownType() && !expectedType.getTypeOfThis().isUnknownType()) {
                FunctionType replacement = FunctionType.builder(this.registry).copyFromOtherFunction(currentType).withTypeOfThis(expectedType.getTypeOfThis()).build();
                return replacement;
            }
        } else if (currentType.getMaxArity() <= expectedType.getMaxArity()) {
            return expectedType;
        }
        return currentType;
    }

    private Map<TemplateType, JSType> inferTemplateTypesFromParameters(FunctionType fnType, Node call, FlowScope scope) {
        if (fnType.getTemplateTypeMap().getTemplateKeys().isEmpty()) {
            return Collections.emptyMap();
        }
        IdentityHashMap<TemplateType, JSType> resolvedTypes = Maps.newIdentityHashMap();
        Set<JSType> seenTypes = Sets.newIdentityHashSet();
        Node callTarget = call.getFirstChild();
        if (NodeUtil.isGet(callTarget)) {
            Node obj = callTarget.getFirstChild();
            JSType typeOfThisRequiredByTheFunction = fnType.getTypeOfThis();
            JSType typeOfThisProvidedByTheCall = obj.isSuper() ? scope.getTypeOfThis() : this.getJSType(obj);
            typeOfThisProvidedByTheCall = typeOfThisProvidedByTheCall.restrictByNotNullOrUndefined();
            this.maybeResolveTemplatedType(typeOfThisRequiredByTheFunction, typeOfThisProvidedByTheCall, resolvedTypes, seenTypes);
        }
        if (call.isTaggedTemplateLit()) {
            Iterator<Node> fnParameters = fnType.getParameters().iterator();
            if (!fnParameters.hasNext()) {
                return resolvedTypes;
            }
            this.maybeResolveTemplatedType(fnParameters.next().getJSType(), this.getNativeType(JSTypeNative.I_TEMPLATE_ARRAY_TYPE), resolvedTypes, seenTypes);
            this.maybeResolveTemplateTypeFromNodes(Iterables.skip(fnType.getParameters(), 1), NodeUtil.getInvocationArgsAsIterable(call), resolvedTypes, seenTypes);
        } else if (call.hasMoreThanOneChild()) {
            this.maybeResolveTemplateTypeFromNodes(fnType.getParameters(), NodeUtil.getInvocationArgsAsIterable(call), resolvedTypes, seenTypes);
        }
        return resolvedTypes;
    }

    private void maybeResolveTemplatedType(JSType paramType, JSType argType, Map<TemplateType, JSType> resolvedTypes, Set<JSType> seenTypes) {
        TemplatizedType templatizedParamType;
        int keyCount;
        if (paramType.isTemplateType()) {
            TypeInference.resolvedTemplateType(resolvedTypes, paramType.toMaybeTemplateType(), argType);
            return;
        }
        if (paramType.isUnionType()) {
            UnionType unionType = paramType.toMaybeUnionType();
            for (JSType alternate : unionType.getAlternates()) {
                this.maybeResolveTemplatedType(alternate, argType, resolvedTypes, seenTypes);
            }
            return;
        }
        if (argType.isUnionType()) {
            UnionType unionType = argType.toMaybeUnionType();
            for (JSType alternate : unionType.getAlternates()) {
                this.maybeResolveTemplatedType(paramType, alternate, resolvedTypes, seenTypes);
            }
            return;
        }
        if (paramType.isFunctionType()) {
            FunctionType paramFunctionType = paramType.toMaybeFunctionType();
            FunctionType argFunctionType = argType.restrictByNotNullOrUndefined().collapseUnion().toMaybeFunctionType();
            if (argFunctionType != null && argFunctionType.isSubtype(paramType)) {
                this.maybeResolveTemplatedType(paramFunctionType.getTypeOfThis(), argFunctionType.getTypeOfThis(), resolvedTypes, seenTypes);
                this.maybeResolveTemplatedType(paramFunctionType.getReturnType(), argFunctionType.getReturnType(), resolvedTypes, seenTypes);
                this.maybeResolveTemplateTypeFromNodes(paramFunctionType.getParameters(), argFunctionType.getParameters(), resolvedTypes, seenTypes);
            }
        } else if (paramType.isRecordType() && !paramType.isNominalType()) {
            if (seenTypes.add(paramType)) {
                ObjectType paramRecordType = paramType.toObjectType();
                ObjectType argObjectType = argType.restrictByNotNullOrUndefined().toObjectType();
                if (argObjectType != null && !argObjectType.isUnknownType() && !argObjectType.isEmptyType()) {
                    Set<String> names = paramRecordType.getPropertyNames();
                    for (String name : names) {
                        if (!paramRecordType.hasOwnProperty(name) || !argObjectType.hasProperty(name)) continue;
                        this.maybeResolveTemplatedType(paramRecordType.getPropertyType(name), argObjectType.getPropertyType(name), resolvedTypes, seenTypes);
                    }
                }
                seenTypes.remove(paramType);
            }
        } else if (paramType.isTemplatizedType() && (keyCount = (templatizedParamType = paramType.toMaybeTemplatizedType()).getTemplateTypes().size()) > 0) {
            ObjectType referencedParamType = templatizedParamType.getReferencedType();
            JSType argObjectType = argType.restrictByNotNullOrUndefined().collapseUnion();
            if (argObjectType.isSubtypeOf(referencedParamType)) {
                TemplateTypeMap paramTypeMap = paramType.getTemplateTypeMap();
                ImmutableList<TemplateType> keys = paramTypeMap.getTemplateKeys();
                TemplateTypeMap argTypeMap = argObjectType.getTemplateTypeMap();
                for (int index = keys.size() - keyCount; index < keys.size(); ++index) {
                    TemplateType key = (TemplateType)keys.get(index);
                    this.maybeResolveTemplatedType(paramTypeMap.getResolvedTemplateType(key), argTypeMap.getResolvedTemplateType(key), resolvedTypes, seenTypes);
                }
            }
        }
    }

    private void maybeResolveTemplateTypeFromNodes(Iterable<Node> declParams, Iterable<Node> callParams, Map<TemplateType, JSType> resolvedTypes, Set<JSType> seenTypes) {
        this.maybeResolveTemplateTypeFromNodes(declParams.iterator(), callParams.iterator(), resolvedTypes, seenTypes);
    }

    private void maybeResolveTemplateTypeFromNodes(Iterator<Node> declParams, Iterator<Node> callParams, Map<TemplateType, JSType> resolvedTypes, Set<JSType> seenTypes) {
        while (declParams.hasNext() && callParams.hasNext()) {
            Node declParam = declParams.next();
            this.maybeResolveTemplatedType(this.getJSType(declParam), this.getJSType(callParams.next()), resolvedTypes, seenTypes);
            if (!declParam.isVarArgs()) continue;
            while (callParams.hasNext()) {
                this.maybeResolveTemplatedType(this.getJSType(declParam), this.getJSType(callParams.next()), resolvedTypes, seenTypes);
            }
        }
    }

    private static void resolvedTemplateType(Map<TemplateType, JSType> map, TemplateType template, JSType resolved) {
        JSType previous = map.get(template);
        if (!resolved.isUnknownType()) {
            if (previous == null) {
                if (template.getBound().isUnknownType()) {
                    map.put(template, resolved);
                } else {
                    JSType meet = template.getBound().getGreatestSubtype(resolved);
                    map.put(template, meet);
                }
            } else {
                JSType join = previous.getLeastSupertype(resolved);
                map.put(template, join);
            }
        }
    }

    private Map<String, JSType> buildTypeVariables(Map<TemplateType, JSType> inferredTypes) {
        LinkedHashMap<String, JSType> typeVars = new LinkedHashMap<String, JSType>();
        for (Map.Entry<TemplateType, JSType> e : inferredTypes.entrySet()) {
            if (e.getKey().isTypeTransformation()) continue;
            typeVars.put(e.getKey().getReferenceName(), e.getValue());
        }
        return typeVars;
    }

    private Map<TemplateType, JSType> evaluateTypeTransformations(ImmutableList<TemplateType> templateTypes, Map<TemplateType, JSType> inferredTypes, FlowScope scope) {
        Map<String, JSType> typeVars = null;
        LinkedHashMap<TemplateType, JSType> result = null;
        TypeTransformation ttlObj = null;
        for (TemplateType type : templateTypes) {
            if (!type.isTypeTransformation()) continue;
            if (ttlObj == null) {
                ttlObj = new TypeTransformation(this.compiler, scope.getDeclarationScope());
                typeVars = this.buildTypeVariables(inferredTypes);
                result = new LinkedHashMap<TemplateType, JSType>();
            }
            JSType transformedType = ttlObj.eval(type.getTypeTransformation(), ImmutableMap.copyOf(typeVars));
            result.put(type, transformedType);
            typeVars.put(type.getReferenceName(), transformedType);
        }
        return result;
    }

    private boolean inferTemplatedTypesForCall(Node n, FunctionType fnType, FlowScope scope) {
        ImmutableList<TemplateType> keys = fnType.getTemplateTypeMap().getTemplateKeys();
        if (keys.isEmpty()) {
            return false;
        }
        Map<TemplateType, JSType> rawInferrence = this.inferTemplateTypesFromParameters(fnType, n, scope);
        IdentityHashMap<TemplateType, JSType> inferred = Maps.newIdentityHashMap();
        for (TemplateType key : keys) {
            JSType type = rawInferrence.get(key);
            if (type == null) {
                type = this.unknownType;
            }
            inferred.put(key, type);
        }
        Map<TemplateType, JSType> typeTransformations = this.evaluateTypeTransformations(keys, inferred, scope);
        if (typeTransformations != null) {
            inferred.putAll(typeTransformations);
        }
        TemplateTypeReplacer replacer = TemplateTypeReplacer.forInference(this.registry, inferred);
        Node callTarget = n.getFirstChild();
        FunctionType replacementFnType = fnType.visit(replacer).toMaybeFunctionType();
        Preconditions.checkNotNull(replacementFnType);
        callTarget.setJSType(replacementFnType);
        n.setJSType(replacementFnType.getReturnType());
        return replacer.hasMadeReplacement();
    }

    private FlowScope traverseNew(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        Node constructor = n.getFirstChild();
        JSType constructorType = constructor.getJSType();
        return this.traverseInstantiation(n, constructorType, scope);
    }

    private FlowScope traverseInstantiation(Node n, JSType constructorType, FlowScope scope) {
        ObjectType type = null;
        if (constructorType != null) {
            if ((constructorType = constructorType.restrictByNotNullOrUndefined()).isUnknownType()) {
                type = this.unknownType;
            } else {
                FunctionType ct = constructorType.toMaybeFunctionType();
                if (ct == null && constructorType instanceof FunctionType) {
                    ct = (FunctionType)constructorType;
                }
                if (ct != null && ct.isConstructor()) {
                    this.backwardsInferenceFromCallSite(n, ct, scope);
                    ObjectType instanceType = ct.getInstanceType();
                    Map<TemplateType, JSType> inferredTypes = this.inferTemplateTypesFromParameters(ct, n, scope);
                    type = inferredTypes.isEmpty() ? instanceType : this.registry.createTemplatizedType(instanceType, inferredTypes);
                }
            }
        }
        n.setJSType(type);
        return scope;
    }

    private BooleanOutcomePair traverseAnd(Node n, FlowScope scope) {
        return this.traverseShortCircuitingBinOp(n, scope);
    }

    private FlowScope traverseChildren(Node n, FlowScope scope) {
        for (Node el = n.getFirstChild(); el != null; el = el.getNext()) {
            scope = this.traverse(el, scope);
        }
        return scope;
    }

    private FlowScope traverseGetElem(Node n, FlowScope scope) {
        scope = this.traverseChildren(n, scope);
        Node indexKey = n.getLastChild();
        JSType indexType = this.getJSType(indexKey);
        if (indexType.isSymbolValueType()) {
            n.setJSType(this.unknownType);
        } else {
            JSType type = this.getJSType(n.getFirstChild()).restrictByNotNullOrUndefined();
            TemplateTypeMap typeMap = type.getTemplateTypeMap();
            if (typeMap.hasTemplateType(this.registry.getObjectElementKey())) {
                n.setJSType(typeMap.getResolvedTemplateType(this.registry.getObjectElementKey()));
            }
        }
        return this.tightenTypeAfterDereference(n.getFirstChild(), scope);
    }

    private FlowScope traverseGetProp(Node n, FlowScope scope) {
        Node objNode = n.getFirstChild();
        Node property = n.getLastChild();
        scope = this.traverseChildren(n, scope);
        n.setJSType(this.getPropertyType(objNode.getJSType(), property.getString(), n, scope));
        return this.tightenTypeAfterDereference(n.getFirstChild(), scope);
    }

    private static void inferPropertyTypesToMatchConstraint(JSType type, JSType constraint) {
        if (type == null || constraint == null) {
            return;
        }
        type.matchConstraint(constraint);
    }

    private FlowScope tightenTypeAfterDereference(Node n, FlowScope scope) {
        JSType narrowed;
        JSType type;
        if (n.isQualifiedName() && !(type = this.getJSType(n)).equals(narrowed = type.restrictByNotNullOrUndefined())) {
            scope = this.narrowScope(scope, n, narrowed);
        }
        return scope;
    }

    private JSType getPropertyType(JSType objType, String propName, Node n, FlowScope scope) {
        ObjectType regType;
        JSType foundType;
        JSType varType;
        StaticTypedSlot var;
        JSType propertyType = null;
        boolean isLocallyInferred = false;
        String qualifiedName = n.getQualifiedName();
        StaticTypedSlot staticTypedSlot = var = qualifiedName != null ? scope.getSlot(qualifiedName) : null;
        if (var != null && (varType = var.getType()) != null) {
            boolean isDeclared = !var.isTypeInferred();
            boolean bl = isLocallyInferred = var != TypeInference.getDeclaredVar(scope, qualifiedName);
            if (isDeclared || isLocallyInferred) {
                propertyType = varType;
            }
        }
        if (propertyType == null && objType != null && (foundType = objType.findPropertyType(propName)) != null) {
            propertyType = foundType;
        }
        if ((propertyType == null || propertyType.isUnknownType()) && qualifiedName != null && (regType = ObjectType.cast(this.registry.getType(scope.getDeclarationScope(), qualifiedName))) != null) {
            propertyType = regType.getConstructor();
        }
        if (propertyType == null) {
            return this.unknownType;
        }
        if (propertyType.isEquivalentTo(this.unknownType) && isLocallyInferred) {
            return this.getNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE);
        }
        return propertyType;
    }

    private BooleanOutcomePair traverseOr(Node n, FlowScope scope) {
        return this.traverseShortCircuitingBinOp(n, scope);
    }

    private BooleanOutcomePair traverseShortCircuitingBinOp(Node n, FlowScope scope) {
        BooleanOutcomePair outcome;
        JSType type;
        Preconditions.checkArgument(n.isAnd() || n.isOr());
        boolean nIsAnd = n.isAnd();
        Node left = n.getFirstChild();
        Node right = n.getLastChild();
        BooleanOutcomePair leftOutcome = this.traverseWithinShortCircuitingBinOp(left, scope);
        JSType leftType = left.getJSType();
        FlowScope rightScope = this.reverseInterpreter.getPreciserScopeKnowingConditionOutcome(left, leftOutcome.getOutcomeFlowScope(left.getToken(), nIsAnd), nIsAnd);
        BooleanOutcomePair rightOutcome = this.traverseWithinShortCircuitingBinOp(right, rightScope);
        JSType rightType = right.getJSType();
        if (leftType != null && rightType != null) {
            leftType = leftType.getRestrictedTypeGivenToBooleanOutcome(!nIsAnd);
            if (leftOutcome.toBooleanOutcomes == BooleanLiteralSet.get(!nIsAnd)) {
                type = leftType;
                outcome = leftOutcome;
            } else {
                type = leftType.getLeastSupertype(rightType);
                outcome = new BooleanOutcomePair(TypeInference.joinBooleanOutcomes(nIsAnd, leftOutcome.toBooleanOutcomes, rightOutcome.toBooleanOutcomes), TypeInference.joinBooleanOutcomes(nIsAnd, leftOutcome.booleanValues, rightOutcome.booleanValues), leftOutcome.getJoinedFlowScope(), rightOutcome.getJoinedFlowScope());
            }
            if (outcome.booleanValues == BooleanLiteralSet.EMPTY && this.getNativeType(JSTypeNative.BOOLEAN_TYPE).isSubtypeOf(type) && type.isUnionType()) {
                type = type.toMaybeUnionType().getRestrictedUnion(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
            }
        } else {
            type = null;
            outcome = new BooleanOutcomePair(BooleanLiteralSet.BOTH, BooleanLiteralSet.BOTH, leftOutcome.getJoinedFlowScope(), rightOutcome.getJoinedFlowScope());
        }
        n.setJSType(type);
        return outcome;
    }

    private BooleanOutcomePair traverseWithinShortCircuitingBinOp(Node n, FlowScope scope) {
        switch (n.getToken()) {
            case AND: {
                return this.traverseAnd(n, scope);
            }
            case OR: {
                return this.traverseOr(n, scope);
            }
        }
        scope = this.traverse(n, scope);
        return this.newBooleanOutcomePair(n.getJSType(), scope);
    }

    private FlowScope traverseAwait(Node await, FlowScope scope) {
        scope = this.traverseChildren(await, scope);
        Node expr = await.getFirstChild();
        JSType exprType = this.getJSType(expr);
        await.setJSType(Promises.getResolvedType(this.registry, exprType));
        return scope;
    }

    private static BooleanLiteralSet joinBooleanOutcomes(boolean isAnd, BooleanLiteralSet left, BooleanLiteralSet right) {
        return right.union(left.intersection(BooleanLiteralSet.get(!isAnd)));
    }

    private BooleanOutcomePair newBooleanOutcomePair(JSType jsType, FlowScope flowScope) {
        if (jsType == null) {
            return new BooleanOutcomePair(BooleanLiteralSet.BOTH, BooleanLiteralSet.BOTH, flowScope, flowScope);
        }
        return new BooleanOutcomePair(jsType.getPossibleToBooleanOutcomes(), this.registry.getNativeType(JSTypeNative.BOOLEAN_TYPE).isSubtypeOf(jsType) ? BooleanLiteralSet.BOTH : BooleanLiteralSet.EMPTY, flowScope, flowScope);
    }

    @CheckReturnValue
    private FlowScope redeclareSimpleVar(FlowScope scope, Node nameNode, JSType varType) {
        Preconditions.checkState(nameNode.isName(), nameNode);
        String varName = nameNode.getString();
        if (varType == null) {
            varType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (this.isUnflowable(TypeInference.getDeclaredVar(scope, varName))) {
            return scope;
        }
        return scope.inferSlotType(varName, varType);
    }

    private boolean isUnflowable(TypedVar v) {
        return v != null && v.isLocal() && v.isMarkedEscaped() && ((TypedScope)v.getScope()).getClosestContainerScope() == this.containerScope;
    }

    private JSType getJSType(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.unknownType;
        }
        return jsType;
    }

    private JSType getNativeType(JSTypeNative typeId) {
        return this.registry.getNativeType(typeId);
    }

    private static TypedVar getDeclaredVar(FlowScope scope, String name) {
        return ((TypedScope)scope.getDeclarationScope()).getVar(name);
    }

    private final class BooleanOutcomePair {
        final BooleanLiteralSet toBooleanOutcomes;
        final BooleanLiteralSet booleanValues;
        final FlowScope leftScope;
        final FlowScope rightScope;
        FlowScope joinedScope = null;

        BooleanOutcomePair(BooleanLiteralSet toBooleanOutcomes, BooleanLiteralSet booleanValues, FlowScope leftScope, FlowScope rightScope) {
            this.toBooleanOutcomes = toBooleanOutcomes;
            this.booleanValues = booleanValues;
            this.leftScope = leftScope;
            this.rightScope = rightScope;
        }

        FlowScope getJoinedFlowScope() {
            if (this.joinedScope == null) {
                this.joinedScope = this.leftScope == this.rightScope ? this.rightScope : TypeInference.this.join(this.leftScope, this.rightScope);
            }
            return this.joinedScope;
        }

        FlowScope getOutcomeFlowScope(Token nodeType, boolean outcome) {
            if (nodeType == Token.AND && outcome || nodeType == Token.OR && !outcome) {
                return this.rightScope;
            }
            return this.getJoinedFlowScope();
        }
    }

    private static enum AssignmentType {
        DECLARATION,
        ASSIGN;

    }

    static interface TypeDeclaringCallback {
        public FlowScope declareTypeInScope(FlowScope var1, Node var2, @Nullable JSType var3);
    }
}

