/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleImportResolver;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.modules.Binding;
import com.google.javascript.jscomp.modules.Module;
import com.google.javascript.jscomp.modules.ModuleMap;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class PolymerBehaviorExtractor {
    private static final ImmutableSet<String> BEHAVIOR_NAMES_NOT_TO_COPY = ImmutableSet.of("created", "attached", "detached", "attributeChanged", "configure", "ready", new String[]{"properties", "listeners", "observers", "hostAttributes"});
    private static final String GOOG_MODULE_EXPORTS = "exports";
    private final AbstractCompiler compiler;
    private final GlobalNamespace globalNames;
    private final ModuleMetadataMap moduleMetadataMap;
    private final ModuleMap moduleMap;
    private final Table<String, ModuleMetadataMap.ModuleMetadata, ResolveBehaviorNameResult> resolveMemoized = HashBasedTable.create();
    private final Map<String, ResolveBehaviorNameResult> globalResolveMemoized = new HashMap<String, ResolveBehaviorNameResult>();
    private static final ResolveBehaviorNameResult FAILED_RESOLVE_RESULT = new ResolveBehaviorNameResult(null, false, null);

    PolymerBehaviorExtractor(AbstractCompiler compiler, GlobalNamespace globalNames, ModuleMetadataMap moduleMetadataMap, ModuleMap moduleMap) {
        this.compiler = compiler;
        this.globalNames = globalNames;
        this.moduleMetadataMap = moduleMetadataMap;
        this.moduleMap = moduleMap;
    }

    ImmutableList<BehaviorDefinition> extractBehaviors(Node behaviorArray, @Nullable ModuleMetadataMap.ModuleMetadata moduleMetadata) {
        if (behaviorArray == null) {
            return ImmutableList.of();
        }
        if (!behaviorArray.isArrayLit()) {
            this.compiler.report(JSError.make(behaviorArray, PolymerPassErrors.POLYMER_INVALID_BEHAVIOR_ARRAY, new String[0]));
            return ImmutableList.of();
        }
        ImmutableList.Builder behaviors = ImmutableList.builder();
        for (Node behaviorName : behaviorArray.children()) {
            if (behaviorName.isObjectLit()) {
                PolymerPassStaticUtils.switchDollarSignPropsToBrackets(behaviorName, this.compiler);
                PolymerPassStaticUtils.quoteListenerAndHostAttributeKeys(behaviorName, this.compiler);
                if (NodeUtil.getFirstPropMatchingKey(behaviorName, "is") != null) {
                    this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_INVALID_BEHAVIOR, new String[0]));
                }
                behaviors.add(new BehaviorDefinition(PolymerPassStaticUtils.extractProperties(behaviorName, PolymerClassDefinition.DefinitionType.ObjectLiteral, this.compiler, null), PolymerBehaviorExtractor.getBehaviorFunctionsToCopy(behaviorName), PolymerBehaviorExtractor.getNonPropertyMembersToCopy(behaviorName), !NodeUtil.isInFunction(behaviorName), (FeatureSet)NodeUtil.getEnclosingScript(behaviorName).getProp(Node.FEATURE_SET)));
                continue;
            }
            ResolveBehaviorNameResult resolveResult = this.resolveBehaviorName(PolymerBehaviorExtractor.getQualifiedNameThroughCast(behaviorName), moduleMetadata);
            if (resolveResult.equals(FAILED_RESOLVE_RESULT)) {
                this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
                continue;
            }
            Node behaviorValue = resolveResult.node;
            if (behaviorValue.isArrayLit()) {
                behaviors.addAll(this.extractBehaviors(behaviorValue, resolveResult.moduleMetadata));
                continue;
            }
            if (behaviorValue.isObjectLit()) {
                PolymerPassStaticUtils.switchDollarSignPropsToBrackets(behaviorValue, this.compiler);
                PolymerPassStaticUtils.quoteListenerAndHostAttributeKeys(behaviorValue, this.compiler);
                if (NodeUtil.getFirstPropMatchingKey(behaviorValue, "is") != null) {
                    this.compiler.report(JSError.make(behaviorValue, PolymerPassErrors.POLYMER_INVALID_BEHAVIOR, new String[0]));
                }
                behaviors.add(new BehaviorDefinition(PolymerPassStaticUtils.extractProperties(behaviorValue, PolymerClassDefinition.DefinitionType.ObjectLiteral, this.compiler, null), PolymerBehaviorExtractor.getBehaviorFunctionsToCopy(behaviorValue), PolymerBehaviorExtractor.getNonPropertyMembersToCopy(behaviorValue), resolveResult.isGlobalDeclaration, (FeatureSet)NodeUtil.getEnclosingScript(behaviorValue).getProp(Node.FEATURE_SET)));
                continue;
            }
            this.compiler.report(JSError.make(behaviorName, PolymerPassErrors.POLYMER_UNQUALIFIED_BEHAVIOR, new String[0]));
        }
        return behaviors.build();
    }

    private ResolveBehaviorNameResult resolveBehaviorName(@Nullable String name, ModuleMetadataMap.ModuleMetadata moduleMetadata) {
        ResolveBehaviorNameResult memoized;
        if (name == null) {
            return FAILED_RESOLVE_RESULT;
        }
        ResolveBehaviorNameResult resolveBehaviorNameResult = memoized = moduleMetadata != null ? this.resolveMemoized.get(name, moduleMetadata) : this.globalResolveMemoized.get(name);
        if (memoized == null) {
            memoized = Preconditions.checkNotNull(this.resolveBehaviorNameInternal(name, moduleMetadata));
            if (moduleMetadata != null) {
                this.resolveMemoized.put(name, moduleMetadata, memoized);
            } else {
                this.globalResolveMemoized.put(name, memoized);
            }
        }
        return memoized;
    }

    private ResolveBehaviorNameResult resolveBehaviorNameInternal(String name, ModuleMetadataMap.ModuleMetadata moduleMetadata) {
        GlobalNamespace.Name globalName;
        ResolveBehaviorNameResult result = this.getNameIfModuleImport(name, moduleMetadata);
        if (result != null) {
            return result;
        }
        ResolveBehaviorNameResult legacyResolve = this.resolveReferenceToLegacyGoogModule(name);
        if (legacyResolve != null) {
            return legacyResolve;
        }
        GlobalNamespace.Name moduleLevelName = moduleMetadata != null ? this.globalNames.getNameFromModule(moduleMetadata, name) : null;
        GlobalNamespace.Name name2 = globalName = moduleLevelName == null ? this.globalNames.getSlot(name) : moduleLevelName;
        if (globalName == null) {
            return FAILED_RESOLVE_RESULT;
        }
        boolean isGlobalDeclaration = moduleLevelName == null;
        GlobalNamespace.Ref declarationRef = globalName.getDeclaration();
        if (declarationRef == null) {
            for (GlobalNamespace.Ref ref : globalName.getRefs()) {
                if (!ref.isSet()) continue;
                isGlobalDeclaration = false;
                declarationRef = ref;
                break;
            }
        }
        if (declarationRef == null) {
            return FAILED_RESOLVE_RESULT;
        }
        Node declarationNode = declarationRef.getNode();
        if (declarationNode == null) {
            return FAILED_RESOLVE_RESULT;
        }
        Node rValue = NodeUtil.getRValueOfLValue(declarationNode);
        if (rValue == null) {
            return FAILED_RESOLVE_RESULT;
        }
        if (rValue.isQualifiedName()) {
            Scope declarationScope = (Scope)declarationRef.scope.getClosestHoistScope();
            Module m = ModuleImportResolver.getModuleFromScopeRoot(this.compiler.getModuleMap(), this.compiler, declarationScope.getRootNode());
            return this.resolveBehaviorName(PolymerBehaviorExtractor.getQualifiedNameThroughCast(rValue), m != null ? m.metadata() : null);
        }
        JSDocInfo behaviorInfo = NodeUtil.getBestJSDocInfo(declarationNode);
        if (behaviorInfo == null || !behaviorInfo.isPolymerBehavior()) {
            this.compiler.report(JSError.make(declarationNode, PolymerPassErrors.POLYMER_UNANNOTATED_BEHAVIOR, new String[0]));
        }
        return new ResolveBehaviorNameResult(rValue, isGlobalDeclaration, moduleMetadata);
    }

    private ResolveBehaviorNameResult resolveReferenceToLegacyGoogModule(String name) {
        int dot = name.length();
        while (dot >= 0) {
            String subNamespace = name.substring(0, dot);
            ModuleMetadataMap.ModuleMetadata metadata = this.moduleMetadataMap.getModulesByGoogNamespace().get(subNamespace);
            if (metadata == null || !metadata.isLegacyGoogModule()) {
                dot = name.lastIndexOf(46, dot - 1);
                continue;
            }
            String rest = dot == name.length() ? "" : name.substring(dot);
            ResolveBehaviorNameResult result = this.resolveBehaviorName(GOOG_MODULE_EXPORTS + rest, metadata);
            return result.equals(FAILED_RESOLVE_RESULT) ? null : result;
        }
        return null;
    }

    private ResolveBehaviorNameResult getNameIfModuleImport(String name, ModuleMetadataMap.ModuleMetadata metadata) {
        String originatingName;
        String rest;
        if (metadata == null || !metadata.isEs6Module() && !metadata.isGoogModule()) {
            return null;
        }
        Module module = metadata.isGoogModule() ? this.moduleMap.getClosureModule((String)metadata.googNamespaces().asList().get(0)) : this.moduleMap.getModule(metadata.path());
        Preconditions.checkNotNull(module, metadata);
        int dot = name.indexOf(46);
        String root = dot == -1 ? name : name.substring(0, dot);
        Binding b = module.boundNames().get(root);
        if (b == null || !b.isSomeImport()) {
            return null;
        }
        String string = rest = dot == -1 ? "" : name.substring(dot);
        if (b.isModuleNamespace()) {
            return this.resolveModuleNamespaceBinding(b, rest);
        }
        ModuleMetadataMap.ModuleMetadata importMetadata = b.originatingExport().moduleMetadata();
        if (importMetadata.isEs6Module()) {
            originatingName = b.originatingExport().localName() + rest;
        } else if (importMetadata.isGoogModule()) {
            originatingName = "exports." + b.originatingExport().exportName() + rest;
        } else {
            Preconditions.checkState(importMetadata.isGoogProvide(), importMetadata);
            originatingName = b.closureNamespace() + "." + b.originatingExport().exportName() + rest;
        }
        return this.resolveBehaviorName(originatingName, importMetadata);
    }

    private ResolveBehaviorNameResult resolveModuleNamespaceBinding(Binding b, String rest) {
        if (b.metadata().isGoogModule()) {
            return this.resolveBehaviorName(GOOG_MODULE_EXPORTS + rest, b.metadata());
        }
        if (b.metadata().isGoogProvide()) {
            return this.resolveBehaviorName(b.closureNamespace() + rest, b.metadata());
        }
        Preconditions.checkState(b.metadata().isEs6Module());
        if (rest.isEmpty()) {
            return FAILED_RESOLVE_RESULT;
        }
        int dot = (rest = rest.substring(1)).indexOf(46);
        String exportedName = dot == -1 ? rest : rest.substring(0, dot);
        Module originalModule = this.moduleMap.getModule(b.metadata().path());
        Binding exportBinding = originalModule.namespace().get(exportedName);
        if (exportBinding == null || !exportBinding.isCreatedByEsExport()) {
            return FAILED_RESOLVE_RESULT;
        }
        return this.resolveBehaviorName(exportBinding.originatingExport().localName() + (dot == -1 ? "" : rest.substring(dot)), b.metadata());
    }

    private static ImmutableList<PolymerPass.MemberDefinition> getBehaviorFunctionsToCopy(Node behaviorObjLit) {
        Preconditions.checkState(behaviorObjLit.isObjectLit());
        ImmutableList.Builder functionsToCopy = ImmutableList.builder();
        for (Node keyNode : behaviorObjLit.children()) {
            boolean isFunctionDefinition = keyNode.isStringKey() && keyNode.getFirstChild().isFunction() || keyNode.isMemberFunctionDef();
            if (!isFunctionDefinition || BEHAVIOR_NAMES_NOT_TO_COPY.contains(keyNode.getString())) continue;
            functionsToCopy.add(new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return functionsToCopy.build();
    }

    @Nullable
    private static String getQualifiedNameThroughCast(Node node) {
        if (node.isName()) {
            String name = node.getString();
            return name.isEmpty() ? null : name;
        }
        if (node.isGetProp()) {
            String left = PolymerBehaviorExtractor.getQualifiedNameThroughCast(node.getFirstChild());
            if (left == null) {
                return null;
            }
            String right = node.getLastChild().getString();
            return left + "." + right;
        }
        if (node.isCast()) {
            return PolymerBehaviorExtractor.getQualifiedNameThroughCast(node.getFirstChild());
        }
        return null;
    }

    private static ImmutableList<PolymerPass.MemberDefinition> getNonPropertyMembersToCopy(Node behaviorObjLit) {
        Preconditions.checkState(behaviorObjLit.isObjectLit());
        ImmutableList.Builder membersToCopy = ImmutableList.builder();
        for (Node keyNode : behaviorObjLit.children()) {
            boolean isNonFunctionMember = keyNode.isGetterDef() || keyNode.isStringKey() && !keyNode.getFirstChild().isFunction();
            if (!isNonFunctionMember || BEHAVIOR_NAMES_NOT_TO_COPY.contains(keyNode.getString())) continue;
            membersToCopy.add(new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return membersToCopy.build();
    }

    static final class BehaviorDefinition {
        final List<PolymerPass.MemberDefinition> props;
        final List<PolymerPass.MemberDefinition> functionsToCopy;
        final List<PolymerPass.MemberDefinition> nonPropertyMembersToCopy;
        final boolean isGlobalDeclaration;
        final FeatureSet features;

        BehaviorDefinition(List<PolymerPass.MemberDefinition> props, List<PolymerPass.MemberDefinition> functionsToCopy, List<PolymerPass.MemberDefinition> nonPropertyMembersToCopy, boolean isGlobalDeclaration, FeatureSet features) {
            this.props = props;
            this.functionsToCopy = functionsToCopy;
            this.nonPropertyMembersToCopy = nonPropertyMembersToCopy;
            this.isGlobalDeclaration = isGlobalDeclaration;
            this.features = features;
        }
    }

    private static class ResolveBehaviorNameResult {
        final Node node;
        final boolean isGlobalDeclaration;
        final ModuleMetadataMap.ModuleMetadata moduleMetadata;

        ResolveBehaviorNameResult(Node node, boolean isGlobalDeclaration, ModuleMetadataMap.ModuleMetadata moduleMetadata) {
            this.node = node;
            this.isGlobalDeclaration = isGlobalDeclaration;
            this.moduleMetadata = moduleMetadata;
        }
    }
}

