/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;

public class J2clSuppressWarningsGuard
extends DiagnosticGroupWarningsGuard {
    private static final DiagnosticGroup DEFAULT_J2CL_SUPRRESIONS = new DiagnosticGroup("j2clIncomaptible", DiagnosticGroups.CHECK_STATIC_OVERRIDES, DiagnosticGroups.CHECK_USELESS_CODE, DiagnosticGroups.CONST, DiagnosticGroups.EXTRA_REQUIRE, DiagnosticGroups.LATE_PROVIDE, DiagnosticGroups.MISSING_OVERRIDE, DiagnosticGroups.MISSING_REQUIRE, DiagnosticGroups.STRICT_MODULE_DEP_CHECK, DiagnosticGroups.SUSPICIOUS_CODE, DiagnosticGroups.UNUSED_LOCAL_VARIABLE, DiagnosticGroups.forName("transitionalSuspiciousCodeWarnings"));

    public J2clSuppressWarningsGuard() {
        super(DEFAULT_J2CL_SUPRRESIONS, CheckLevel.OFF);
    }

    @Override
    public boolean disables(DiagnosticGroup type) {
        return false;
    }

    @Override
    public CheckLevel level(JSError error) {
        boolean isJ2clSource = error.sourceName != null && error.sourceName.endsWith(".java.js");
        return isJ2clSource ? super.level(error) : null;
    }

    @Override
    protected int getPriority() {
        return WarningsGuard.Priority.MAX.getValue();
    }
}

